/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.client.gui;

import com.sapphic.kindredsouls.client.gui.KonkreteScreenHandler;
import com.sapphic.kindredsouls.network.C2S_RespondToRequestPacket;
import com.sapphic.kindredsouls.network.C2S_SendRequestPacket;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.RequestData;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.ExtendedEditBox;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RequestScreen
extends Screen {
    private final List<RequestData> requests;
    private final Map<UUID, UUID> boundPlayers;
    private ExtendedEditBox searchPlayerField;
    private AdvancedButton hideBoundCheckbox;
    private AdvancedButton sendGuardianRequestButton;
    private AdvancedButton sendWardRequestButton;
    private AdvancedButton doneButton;
    private ScrollArea playerListArea;
    private ScrollArea requestListArea;
    private UUID selectedTargetPlayerUUID;
    private String selectedTargetPlayerName;
    private boolean hideBound = true;
    private static final Component TITLE = Component.m_237115_((String)"gui.kindred_souls.request_screen.title");
    private static final Component SEND_TITLE = Component.m_237115_((String)"gui.kindred_souls.request_screen.send_title");
    private static final Component LIST_TITLE = Component.m_237115_((String)"gui.kindred_souls.request_screen.list_title");
    private static final Component SEARCH_PLAYER = Component.m_237115_((String)"gui.kindred_souls.search_player");
    private static final Component HIDE_BOUND = Component.m_237115_((String)"gui.kindred_souls.hide_bound");
    private static final Component REQ_GUARDIAN = Component.m_237115_((String)"gui.kindred_souls.roleselect.guardian");
    private static final Component REQ_WARD = Component.m_237115_((String)"gui.kindred_souls.roleselect.ward");
    private static final Component DONE = Component.m_237115_((String)"gui.done");
    private static final Component ACCEPT = Component.m_237115_((String)"gui.kindred_souls.request.accept");
    private static final Component DENY = Component.m_237115_((String)"gui.kindred_souls.request.deny");
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected static final Color BUTTON_COLOR_IDLE = new Color(100, 100, 100);
    protected static final Color BUTTON_COLOR_HOVER = new Color(130, 130, 130);
    protected static final Color BUTTON_COLOR_SELECTED = Color.DARK_GRAY;

    public RequestScreen(List<RequestData> requests, Map<UUID, UUID> boundPlayers) {
        super(TITLE);
        this.requests = requests;
        this.boundPlayers = boundPlayers;
        this.requests.sort((a, b) -> Boolean.compare(a.isOutgoing(), !b.isOutgoing()));
    }

    public boolean isPlayerBound(UUID playerUUID) {
        return this.boundPlayers.containsKey(playerUUID);
    }

    protected void m_7856_() {
        int leftPanelX;
        super.m_7856_();
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        int screenCenterX = this.f_96543_ / 2;
        int currentY = 50;
        int leftPanelWidth = 150;
        int elementX = leftPanelX = screenCenterX - leftPanelWidth - 10;
        int elementWidth = leftPanelWidth;
        this.searchPlayerField = new ExtendedEditBox(this.f_96547_, elementX, currentY, elementWidth, 20, (Component)Component.m_237119_(), true);
        this.searchPlayerField.m_257771_(SEARCH_PLAYER);
        this.searchPlayerField.m_94151_(s -> this.populatePlayerList());
        this.m_142416_((GuiEventListener)this.searchPlayerField);
        this.hideBoundCheckbox = new AdvancedButton(elementX, currentY += 24, elementWidth, 20, "", false, btn -> {
            this.hideBound = !this.hideBound;
            this.updateHideBoundButtonText();
            this.populatePlayerList();
        });
        this.updateHideBoundButtonText();
        this.colorizeButton(this.hideBoundCheckbox);
        this.m_142416_((GuiEventListener)this.hideBoundCheckbox);
        int listBottom = this.f_96544_ - 110;
        int listHeight = listBottom - (currentY += 24);
        this.playerListArea = new ScrollArea(elementX, currentY, elementWidth, listHeight);
        this.playerListArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
        this.m_142416_((GuiEventListener)new KonkreteScreenHandler(this.playerListArea));
        currentY = listBottom + 5;
        this.sendGuardianRequestButton = new AdvancedButton(elementX, currentY, elementWidth, 20, REQ_GUARDIAN.getString(), false, btn -> this.sendRequest("GUARDIAN"));
        this.colorizeButton(this.sendGuardianRequestButton);
        this.m_142416_((GuiEventListener)this.sendGuardianRequestButton);
        this.sendWardRequestButton = new AdvancedButton(elementX, currentY += 24, elementWidth, 20, REQ_WARD.getString(), false, btn -> this.sendRequest("WARD"));
        this.colorizeButton(this.sendWardRequestButton);
        this.m_142416_((GuiEventListener)this.sendWardRequestButton);
        int rightPanelWidth = 200;
        int rightPanelX = screenCenterX + 10;
        currentY = 50;
        int requestListHeight = this.f_96544_ - 100;
        this.requestListArea = new ScrollArea(rightPanelX, currentY, rightPanelWidth, requestListHeight);
        this.requestListArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
        this.m_142416_((GuiEventListener)new KonkreteScreenHandler(this.requestListArea));
        this.populateRequestList();
        this.doneButton = new AdvancedButton((this.f_96543_ - 100) / 2, this.f_96544_ - 35, 100, 20, DONE.getString(), false, btn -> this.m_7379_());
        this.colorizeButton(this.doneButton);
        this.m_142416_((GuiEventListener)this.doneButton);
        this.populatePlayerList();
        this.updateSendRequestButtons();
    }

    private void updateHideBoundButtonText() {
        this.hideBoundCheckbox.m_93666_((Component)Component.m_237113_((String)"").m_7220_(HIDE_BOUND).m_130946_(this.hideBound ? " (ON)" : " (OFF)"));
    }

    private void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(BUTTON_COLOR_IDLE, BUTTON_COLOR_HOVER, BUTTON_COLOR_HOVER, BUTTON_COLOR_HOVER, 1);
    }

    private void colorizeButtonSelected(AdvancedButton b) {
        b.setBackgroundColor(BUTTON_COLOR_SELECTED, BUTTON_COLOR_HOVER, BUTTON_COLOR_HOVER, BUTTON_COLOR_HOVER, 1);
    }

    private void populatePlayerList() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null || this.playerListArea == null) {
            return;
        }
        this.playerListArea.getEntries().clear();
        String searchText = this.searchPlayerField.m_94155_().toLowerCase();
        for (PlayerInfo playerInfo : this.f_96541_.f_91074_.f_108617_.m_105142_()) {
            if (playerInfo.m_105312_() == null || playerInfo.m_105312_().getName() == null || playerInfo.m_105312_().getId().equals(this.f_96541_.f_91074_.m_20148_()) || !playerInfo.m_105312_().getName().toLowerCase().contains(searchText) || this.hideBound && this.isPlayerBound(playerInfo.m_105312_().getId())) continue;
            this.playerListArea.addEntry((ScrollAreaEntry)new PlayerEntryComponent(this.playerListArea, playerInfo));
        }
        if (this.selectedTargetPlayerUUID != null) {
            boolean found = false;
            for (ScrollAreaEntry entry : this.playerListArea.getEntries()) {
                if (!(entry instanceof PlayerEntryComponent) || !((PlayerEntryComponent)entry).playerInfo.m_105312_().getId().equals(this.selectedTargetPlayerUUID)) continue;
                ((PlayerEntryComponent)entry).setSelected(this.selectedTargetPlayerUUID);
                found = true;
            }
            if (!found) {
                this.selectedTargetPlayerUUID = null;
                this.selectedTargetPlayerName = null;
                this.updateSendRequestButtons();
            }
        }
    }

    private void populateRequestList() {
        if (this.requestListArea == null) {
            return;
        }
        this.requestListArea.getEntries().clear();
        for (RequestData request : this.requests) {
            this.requestListArea.addEntry((ScrollAreaEntry)new RequestEntryComponent(this.requestListArea, request));
        }
    }

    public void onPlayerSelected(PlayerInfo playerInfo) {
        this.selectedTargetPlayerName = playerInfo.m_105312_().getName();
        this.selectedTargetPlayerUUID = playerInfo.m_105312_().getId();
        for (ScrollAreaEntry entry : this.playerListArea.getEntries()) {
            if (!(entry instanceof PlayerEntryComponent)) continue;
            ((PlayerEntryComponent)entry).setSelected(playerInfo.m_105312_().getId());
        }
        this.updateSendRequestButtons();
    }

    private void updateSendRequestButtons() {
        boolean playerSelected = this.selectedTargetPlayerUUID != null;
        boolean active = playerSelected && !this.isPlayerBound(this.selectedTargetPlayerUUID);
        this.sendGuardianRequestButton.setUseable(active);
        this.sendWardRequestButton.setUseable(active);
    }

    private void sendRequest(String role) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (this.selectedTargetPlayerUUID == null || this.selectedTargetPlayerName == null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"Please select a player.").m_130940_(ChatFormatting.RED));
            return;
        }
        if (this.selectedTargetPlayerUUID.equals(this.f_96541_.f_91074_.m_20148_())) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"You cannot send a request to yourself.").m_130940_(ChatFormatting.RED));
            return;
        }
        PacketRegistry.sendToServer(new C2S_SendRequestPacket(this.selectedTargetPlayerUUID, role));
        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Sent request to " + this.selectedTargetPlayerName + " to be their " + role + ".")).m_130940_(ChatFormatting.GREEN));
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, SCREEN_BACKGROUND_COLOR.getRGB());
        guiGraphics.m_280509_(0, 0, this.f_96543_, 40, HEADER_FOOTER_COLOR.getRGB());
        guiGraphics.m_280653_(this.f_96547_, TITLE, this.f_96543_ / 2, 10, Color.WHITE.getRGB());
        guiGraphics.m_280653_(this.f_96547_, SEND_TITLE, this.f_96543_ / 2 - 85, 30, Color.WHITE.getRGB());
        guiGraphics.m_280653_(this.f_96547_, LIST_TITLE, this.f_96543_ / 2 + 110, 30, Color.WHITE.getRGB());
        guiGraphics.m_280509_(0, this.f_96544_ - 40, this.f_96543_, this.f_96544_, HEADER_FOOTER_COLOR.getRGB());
        if (this.playerListArea != null) {
            this.playerListArea.render(guiGraphics);
        }
        if (this.requestListArea != null) {
            this.requestListArea.render(guiGraphics);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (PopupHandler.isPopupActive()) {
            PopupHandler.getCurrentPopup().render(guiGraphics, mouseX, mouseY, (Screen)this);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public class PlayerEntryComponent
    extends ScrollAreaEntry {
        private final PlayerInfo playerInfo;
        public final AdvancedButton button;
        private boolean isSelected;

        public PlayerEntryComponent(ScrollArea parent, PlayerInfo playerInfo) {
            super(parent);
            this.isSelected = false;
            this.playerInfo = playerInfo;
            MutableComponent nameComponent = Component.m_237113_((String)playerInfo.m_105312_().getName());
            if (RequestScreen.this.isPlayerBound(playerInfo.m_105312_().getId())) {
                nameComponent = nameComponent.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.STRIKETHROUGH});
            }
            this.button = new AdvancedButton(0, 0, parent.width - parent.grabberwidth * 2, 20, nameComponent.getString(), false, btn -> {
                if (!RequestScreen.this.isPlayerBound(playerInfo.m_105312_().getId())) {
                    RequestScreen.this.onPlayerSelected(playerInfo);
                }
            });
            if (RequestScreen.this.isPlayerBound(playerInfo.m_105312_().getId())) {
                this.button.setUseable(false);
            }
            RequestScreen.this.colorizeButton(this.button);
        }

        public void setSelected(UUID selectedUuid) {
            this.isSelected = this.playerInfo.m_105312_().getId().equals(selectedUuid);
        }

        public void renderEntry(GuiGraphics guiGraphics) {
            if (!this.isVisible()) {
                return;
            }
            this.button.m_252865_(this.x + 1);
            this.button.m_253211_(this.y + 1);
            this.button.m_93674_(this.getWidth() - 2 - this.parent.grabberwidth);
            this.button.setHeight(this.getHeight() - 2);
            if (this.isSelected) {
                RequestScreen.this.colorizeButtonSelected(this.button);
            } else {
                RequestScreen.this.colorizeButton(this.button);
            }
            this.button.m_88315_(guiGraphics, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
            guiGraphics.m_280411_(this.playerInfo.m_105337_(), this.x + 3, this.y + 3, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280411_(this.playerInfo.m_105337_(), this.x + 3, this.y + 3, 16, 16, 40.0f, 8.0f, 8, 8, 64, 64);
        }

        public int getHeight() {
            return 22;
        }
    }

    public class RequestEntryComponent
    extends ScrollAreaEntry {
        private final RequestData request;
        public AdvancedButton acceptButton;
        public AdvancedButton denyButton;

        public RequestEntryComponent(ScrollArea parent, RequestData request) {
            super(parent);
            this.request = request;
            if (!request.isOutgoing()) {
                this.acceptButton = new AdvancedButton(0, 0, 60, 20, ACCEPT.getString(), false, btn -> this.respondToRequest(request.getRequestId(), true, "Accepted request!"));
                RequestScreen.this.colorizeButton(this.acceptButton);
                this.denyButton = new AdvancedButton(0, 0, 60, 20, DENY.getString(), false, btn -> this.respondToRequest(request.getRequestId(), false, "Denied request."));
                RequestScreen.this.colorizeButton(this.denyButton);
            }
        }

        public void renderEntry(GuiGraphics guiGraphics) {
            if (!this.isVisible()) {
                return;
            }
            guiGraphics.m_280509_(this.x, this.y, this.x + this.getWidth() - this.parent.grabberwidth, this.y + this.getHeight() - 1, 0x30FFFFFF);
            if (this.request.isOutgoing()) {
                MutableComponent requestText = Component.m_237113_((String)"To: ").m_7220_((Component)Component.m_237113_((String)this.request.getOtherPlayerName()).m_130940_(ChatFormatting.YELLOW)).m_130946_(" (" + this.request.getRequestedRole() + ")").m_130940_(ChatFormatting.GRAY);
                guiGraphics.m_280430_(RequestScreen.this.f_96547_, (Component)requestText, this.x + 5, this.y + 7, Color.WHITE.getRGB());
            } else {
                MutableComponent requestText = Component.m_237113_((String)"From: ").m_7220_((Component)Component.m_237113_((String)this.request.getOtherPlayerName()).m_130940_(ChatFormatting.GOLD)).m_130946_(" wants to be your " + this.request.getRequestedRole()).m_130940_(ChatFormatting.AQUA);
                guiGraphics.m_280430_(RequestScreen.this.f_96547_, (Component)requestText, this.x + 5, this.y + 5, Color.WHITE.getRGB());
                int buttonY = this.y + 24;
                int buttonXStart = this.x + this.getWidth() - this.parent.grabberwidth - 130;
                this.acceptButton.m_252865_(buttonXStart);
                this.acceptButton.m_253211_(buttonY);
                this.acceptButton.m_88315_(guiGraphics, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
                this.denyButton.m_252865_(buttonXStart + 65);
                this.denyButton.m_253211_(buttonY);
                this.denyButton.m_88315_(guiGraphics, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
            }
        }

        private void respondToRequest(UUID requestId, boolean accepted, String message) {
            PacketRegistry.sendToServer(new C2S_RespondToRequestPacket(requestId, accepted));
            if (RequestScreen.this.f_96541_ != null && ((RequestScreen)RequestScreen.this).f_96541_.f_91074_ != null) {
                ((RequestScreen)RequestScreen.this).f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)message).m_130940_(accepted ? ChatFormatting.GREEN : ChatFormatting.YELLOW));
            }
            RequestScreen.this.m_7379_();
        }

        public int getHeight() {
            return this.request.isOutgoing() ? 22 : 48;
        }
    }
}

