/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.config;

import com.sapphic.kindredsouls.api.AbilityRole;
import com.sapphic.kindredsouls.api.IAbilityType;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.exceptions.InvalidValueException;
import java.io.File;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.sapphic.kindredsouls.KindredSoulsMod;

public class AbilityConfig {
    private static Config config;
    private static final String FILE_PATH;

    public static void init() {
        config = new Config(FILE_PATH);
        config.setConfigName("Kindred Souls Ability Toggles");
    }

    public static void registerAllAbilities() {
        if (config == null) {
            KindredSoulsMod.LOGGER.error("AbilityConfig.init() was not called before registerAllAbilities()");
            AbilityConfig.init();
        }
        KindredSoulsMod.LOGGER.info("Checking for and registering ability types in config...");
        Collection<IAbilityType> allTypes = IKindredSoulsAPI.getInstance().getAbilityRegistry().getTypesForRole(AbilityRole.GUARDIAN);
        allTypes.addAll(IKindredSoulsAPI.getInstance().getAbilityRegistry().getTypesForRole(AbilityRole.WARD));
        boolean needsSync = false;
        for (IAbilityType type : allTypes) {
            String id = type.getId().toString();
            String category = type.getRole().name();
            String description = "Set to false to hide this ability in the selection screen. (" + type.getDisplayName().getString() + ")";
            if (config.valueExists(id)) continue;
            try {
                config.registerValue(id, Boolean.valueOf(true), category, description);
                KindredSoulsMod.LOGGER.info("Registered new ability in config: {}", (Object)id);
                needsSync = true;
            }
            catch (InvalidValueException e) {
                KindredSoulsMod.LOGGER.error("Failed to register ability config entry: " + id, (Throwable)e);
            }
        }
        if (needsSync) {
            config.syncConfig();
            KindredSoulsMod.LOGGER.info("Ability config synced with new entries.");
        } else {
            KindredSoulsMod.LOGGER.info("No new abilities found to register.");
        }
    }

    public static boolean isAbilityEnabled(ResourceLocation id) {
        if (config == null) {
            KindredSoulsMod.LOGGER.error("AbilityConfig is null! Returning true by default.");
            return true;
        }
        String idString = id.toString();
        if (!config.valueExists(idString)) {
            KindredSoulsMod.LOGGER.warn("Ability config missing for {}. Defaulting to enabled. It will be added to the config on the next launch.", (Object)idString);
            return true;
        }
        try {
            return (Boolean)config.getOrDefault(idString, (Object)true);
        }
        catch (Exception e) {
            KindredSoulsMod.LOGGER.error("Failed to read ability config for: " + idString + ". Defaulting to true.", (Throwable)e);
            return true;
        }
    }

    static {
        FILE_PATH = "config" + File.separator + "kindredsouls-abilities.cfg";
    }
}

