/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class RequestData {
    private final UUID requestId;
    private final String otherPlayerName;
    private final String requestedRole;
    private final boolean outgoing;

    public RequestData(UUID requestId, String otherPlayerName, String requestedRole, boolean outgoing) {
        this.requestId = requestId;
        this.otherPlayerName = otherPlayerName;
        this.requestedRole = requestedRole;
        this.outgoing = outgoing;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130077_(this.requestId);
        buf.m_130070_(this.otherPlayerName);
        buf.m_130070_(this.requestedRole);
        buf.writeBoolean(this.outgoing);
    }

    public static RequestData fromBuffer(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        String name = buf.m_130277_();
        String role = buf.m_130277_();
        boolean outgoing = buf.readBoolean();
        return new RequestData(id, name, role, outgoing);
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public String getOtherPlayerName() {
        return this.otherPlayerName;
    }

    public String getRequestedRole() {
        return this.requestedRole;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }
}

