/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.client.ClientSoulbindData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2C_UpdateSoulmateDataPacket {
    private final boolean isOnline;
    private final String soulmateName;
    private final String dimension;
    private final int x;
    private final int y;
    private final int z;
    private final String playerRole;

    public S2C_UpdateSoulmateDataPacket(String soulmateName, String dimension, int x, int y, int z, String playerRole) {
        this.isOnline = true;
        this.soulmateName = soulmateName;
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.playerRole = playerRole;
    }

    public S2C_UpdateSoulmateDataPacket(String soulmateName, String playerRole) {
        this.isOnline = false;
        this.soulmateName = soulmateName;
        this.dimension = "";
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.playerRole = playerRole;
    }

    public static void encode(S2C_UpdateSoulmateDataPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isOnline);
        buf.m_130070_(msg.soulmateName);
        buf.m_130070_(msg.playerRole);
        if (msg.isOnline) {
            buf.m_130070_(msg.dimension);
            buf.writeInt(msg.x);
            buf.writeInt(msg.y);
            buf.writeInt(msg.z);
        }
    }

    public static S2C_UpdateSoulmateDataPacket decode(FriendlyByteBuf buf) {
        boolean isOnline = buf.readBoolean();
        String soulmateName = buf.m_130277_();
        String playerRole = buf.m_130277_();
        if (isOnline) {
            String dimension = buf.m_130277_();
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            return new S2C_UpdateSoulmateDataPacket(soulmateName, dimension, x, y, z, playerRole);
        }
        return new S2C_UpdateSoulmateDataPacket(soulmateName, playerRole);
    }

    public static void handle(S2C_UpdateSoulmateDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSoulbindData.setSoulmateData(msg.isOnline, msg.soulmateName, msg.dimension, msg.x, msg.y, msg.z, msg.playerRole)));
        ctx.get().setPacketHandled(true);
    }
}

