/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.soulbind;

import com.sapphic.kindredsouls.api.AbilityRole;
import com.sapphic.kindredsouls.api.IAbilityType;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.config.AbilityConfig;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.RequestData;
import com.sapphic.kindredsouls.network.S2C_OpenAbilityTypeScreenPacket;
import com.sapphic.kindredsouls.network.S2C_OpenRequestScreenPacket;
import com.sapphic.kindredsouls.network.S2C_UpdatePlayerSoulbindsPacket;
import com.sapphic.kindredsouls.soulbind.SoulbindSaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.sapphic.kindredsouls.KindredSoulsMod;

public class SoulbindManager {
    public static final String GUARDIAN_ROLE = "GUARDIAN";
    public static final String WARD_ROLE = "WARD";
    public static final String ROLE_UNASSIGNED = "UNASSIGNED";
    private static final Map<UUID, Map<UUID, String>> pendingRequests = new ConcurrentHashMap<UUID, Map<UUID, String>>();
    private static final Map<UUID, Map<UUID, String>> outgoingRequests = new ConcurrentHashMap<UUID, Map<UUID, String>>();
    private static MinecraftServer serverInstance;

    public static void setServerInstance(MinecraftServer server) {
        serverInstance = server;
    }

    @Nullable
    public static SoulbindSaveData getSaveData() {
        if (serverInstance == null) {
            KindredSoulsMod.LOGGER.error("Attempted to get SoulbindSaveData, but serverInstance is null!");
            return null;
        }
        ServerLevel overworld = serverInstance.m_129880_(Level.f_46428_);
        if (overworld == null) {
            KindredSoulsMod.LOGGER.error("Attempted to get SoulbindSaveData, but Overworld is null!");
            return null;
        }
        DimensionDataStorage storage = overworld.m_8895_();
        return (SoulbindSaveData)storage.m_164861_(SoulbindSaveData::load, SoulbindSaveData::new, "kindred_souls_soulbind_data");
    }

    public static void setPlayerRole(ServerPlayer player, String role) {
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null) {
            data.getPlayerRoles().put(player.m_20148_(), role);
            data.m_77762_();
            KindredSoulsMod.LOGGER.info("{} is now a {}", (Object)player.m_7755_().getString(), (Object)role);
        }
    }

    public static String getPlayerRole(ServerPlayer player) {
        SoulbindSaveData data = SoulbindManager.getSaveData();
        return data != null ? data.getPlayerRoles().getOrDefault(player.m_20148_(), ROLE_UNASSIGNED) : ROLE_UNASSIGNED;
    }

    public static void setPlayerAbilityType(ServerPlayer player, ResourceLocation typeId) {
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null) {
            if (typeId == null) {
                data.getPlayerAbilityTypes().remove(player.m_20148_());
                KindredSoulsMod.LOGGER.info("Cleared ability type for {}", (Object)player.m_7755_().getString());
            } else {
                data.getPlayerAbilityTypes().put(player.m_20148_(), typeId.toString());
                KindredSoulsMod.LOGGER.info("{} selected ability type: {}", (Object)player.m_7755_().getString(), (Object)typeId);
            }
            data.m_77762_();
        }
    }

    @Nullable
    public static ResourceLocation getPlayerAbilityType(ServerPlayer player) {
        String typeIdStr;
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null && (typeIdStr = data.getPlayerAbilityTypes().get(player.m_20148_())) != null) {
            try {
                return new ResourceLocation(typeIdStr);
            }
            catch (Exception e) {
                KindredSoulsMod.LOGGER.error("Failed to parse ability type ID: {}", (Object)typeIdStr, (Object)e);
                return null;
            }
        }
        return null;
    }

    public static void bindPlayers(ServerPlayer guardian, ServerPlayer ward, boolean sendChatMessages, boolean isTwoWayBind) {
        if (guardian == null || ward == null) {
            return;
        }
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null) {
            UUID guardianUUID = guardian.m_20148_();
            UUID wardUUID = ward.m_20148_();
            Map<UUID, UUID> boundPairs = data.getBoundPairs();
            if (boundPairs.containsKey(wardUUID) && !boundPairs.get(wardUUID).equals(guardianUUID)) {
                if (sendChatMessages) {
                    guardian.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + ward.m_7755_().getString() + " is already bound to another Guardian.")).m_130940_(ChatFormatting.RED));
                }
                return;
            }
            UUID existingWardUUID = null;
            for (Map.Entry<UUID, UUID> entry : boundPairs.entrySet()) {
                if (!entry.getValue().equals(guardianUUID)) continue;
                existingWardUUID = entry.getKey();
                break;
            }
            if (existingWardUUID != null && !existingWardUUID.equals(wardUUID)) {
                if (sendChatMessages) {
                    guardian.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + guardian.m_7755_().getString() + " is already bound as a Guardian to another Ward.")).m_130940_(ChatFormatting.RED));
                }
                return;
            }
            boundPairs.put(wardUUID, guardianUUID);
            data.getIsTwoWay().put(wardUUID, isTwoWayBind);
            data.m_77762_();
            KindredSoulsMod.LOGGER.info("Guardian {} and Ward {} are now soulbound! (TwoWay: {})", (Object)guardian.m_7755_().getString(), (Object)ward.m_7755_().getString(), (Object)isTwoWayBind);
            if (sendChatMessages) {
                guardian.m_213846_((Component)Component.m_237113_((String)("\u00a7aYou are now bound to " + ward.m_7755_().getString() + " as their Guardian!")).m_130940_(ChatFormatting.GREEN));
                ward.m_213846_((Component)Component.m_237113_((String)("\u00a7aYou are now bound to " + guardian.m_7755_().getString() + " as their Ward!")).m_130940_(ChatFormatting.GREEN));
            }
            SoulbindManager.sendUpdatedSoulbindsToAllClients();
        }
    }

    public static void unbindPlayer(ServerPlayer player) {
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null) {
            UUID playerUUID = player.m_20148_();
            Map<UUID, UUID> boundPairs = data.getBoundPairs();
            Map<UUID, Boolean> isTwoWayMap = data.getIsTwoWay();
            UUID partnerUUID = null;
            UUID wardToRemove = null;
            if (boundPairs.containsKey(playerUUID)) {
                partnerUUID = boundPairs.remove(playerUUID);
                isTwoWayMap.remove(playerUUID);
            } else {
                for (Map.Entry<UUID, UUID> entry : boundPairs.entrySet()) {
                    if (!entry.getValue().equals(playerUUID)) continue;
                    partnerUUID = wardToRemove = entry.getKey();
                    break;
                }
                if (wardToRemove != null) {
                    boundPairs.remove(wardToRemove);
                    isTwoWayMap.remove(wardToRemove);
                }
            }
            if (partnerUUID != null) {
                ServerPlayer partner;
                data.m_77762_();
                KindredSoulsMod.LOGGER.info("{} has been unbound.", (Object)player.m_7755_().getString());
                SoulbindManager.setPlayerAbilityType(player, null);
                ServerPlayer serverPlayer = partner = serverInstance != null ? serverInstance.m_6846_().m_11259_(partnerUUID) : null;
                if (partner != null) {
                    partner.m_213846_((Component)Component.m_237113_((String)("\u00a7eYour soulbind with " + player.m_7755_().getString() + " has been broken.")).m_130940_(ChatFormatting.YELLOW));
                    SoulbindManager.setPlayerRole(partner, ROLE_UNASSIGNED);
                    SoulbindManager.setPlayerAbilityType(partner, null);
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7eYour soulbind with " + (partner != null ? partner.m_7755_().getString() : "an unknown player") + " has been broken.")).m_130940_(ChatFormatting.YELLOW));
                SoulbindManager.setPlayerRole(player, ROLE_UNASSIGNED);
                SoulbindManager.sendUpdatedSoulbindsToAllClients();
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou are not currently soulbound.").m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static UUID getSoulmate(ServerPlayer player) {
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data == null) {
            return null;
        }
        UUID playerUUID = player.m_20148_();
        Map<UUID, UUID> boundPairs = data.getBoundPairs();
        if (boundPairs.containsKey(playerUUID)) {
            return boundPairs.get(playerUUID);
        }
        for (Map.Entry<UUID, UUID> entry : boundPairs.entrySet()) {
            if (!entry.getValue().equals(playerUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void handleSoulbindRequest(ServerPlayer requester, ServerPlayer target, String role) {
        UUID requesterUUID = requester.m_20148_();
        UUID targetUUID = target.m_20148_();
        if (SoulbindManager.getSoulmate(requester) != null) {
            requester.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou are already soulbound.").m_130940_(ChatFormatting.RED));
            return;
        }
        if (SoulbindManager.getSoulmate(target) != null) {
            requester.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + target.m_7755_().getString() + " is already soulbound.")).m_130940_(ChatFormatting.RED));
            return;
        }
        if (pendingRequests.containsKey(targetUUID) && pendingRequests.get(targetUUID).containsKey(requesterUUID)) {
            requester.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou already sent a request to this player.").m_130940_(ChatFormatting.RED));
            return;
        }
        if (pendingRequests.containsKey(requesterUUID) && pendingRequests.get(requesterUUID).containsKey(targetUUID)) {
            requester.m_213846_((Component)Component.m_237113_((String)("\u00a7e" + target.m_7755_().getString() + " has already sent you a request! Check your requests.")).m_130940_(ChatFormatting.YELLOW));
            return;
        }
        if (outgoingRequests.containsKey(requesterUUID) && outgoingRequests.get(requesterUUID).containsKey(targetUUID)) {
            requester.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou already sent a request to this player.").m_130940_(ChatFormatting.RED));
            return;
        }
        pendingRequests.computeIfAbsent(targetUUID, k -> new ConcurrentHashMap()).put(requesterUUID, role);
        outgoingRequests.computeIfAbsent(requesterUUID, k -> new ConcurrentHashMap()).put(targetUUID, role);
        requester.m_213846_((Component)Component.m_237113_((String)("\u00a7aRequest sent to " + target.m_7755_().getString() + " to be their " + role + ".")).m_130940_(ChatFormatting.GREEN));
        target.m_213846_((Component)Component.m_237113_((String)("\u00a7e" + requester.m_7755_().getString() + " wants to be your " + role + "! Open the request menu (keybind) to respond.")).m_130940_(ChatFormatting.YELLOW));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void handleRequestResponse(ServerPlayer responder, UUID requesterUUID, boolean accepted) {
        ServerPlayer requester;
        String requestedRole;
        block13: {
            block12: {
                UUID responderUUID = responder.m_20148_();
                Map<UUID, String> incomingForResponder = pendingRequests.get(responderUUID);
                requestedRole = null;
                if (incomingForResponder != null) {
                    requestedRole = incomingForResponder.remove(requesterUUID);
                    if (incomingForResponder.isEmpty()) {
                        pendingRequests.remove(responderUUID);
                    }
                }
                if (requestedRole == null) {
                    responder.m_213846_((Component)Component.m_237113_((String)"\u00a7cRequest not found or expired.").m_130940_(ChatFormatting.RED));
                    return;
                }
                ServerPlayer serverPlayer = requester = serverInstance != null ? serverInstance.m_6846_().m_11259_(requesterUUID) : null;
                if (requester == null) break block12;
                Map<UUID, String> outgoingForRequester = outgoingRequests.get(requesterUUID);
                if (outgoingForRequester != null) {
                    outgoingForRequester.remove(responderUUID);
                    if (outgoingForRequester.isEmpty()) {
                        outgoingRequests.remove(requesterUUID);
                    }
                }
                break block13;
            }
            outgoingRequests.remove(requesterUUID);
            if (!accepted) {
                responder.m_213846_((Component)Component.m_237113_((String)"\u00a7eThe requester logged out. Request auto-cancelled.").m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (accepted) {
            if (requester == null) {
                responder.m_213846_((Component)Component.m_237113_((String)"\u00a7eThe requester logged out before the request could be accepted.").m_130940_(ChatFormatting.YELLOW));
                return;
            }
            if (SoulbindManager.getSoulmate(responder) != null) {
                responder.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou became soulbound while processing the request. Binding failed.").m_130940_(ChatFormatting.RED));
                requester.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + responder.m_7755_().getString() + " became soulbound. Request failed.")).m_130940_(ChatFormatting.RED));
                return;
            }
            if (SoulbindManager.getSoulmate(requester) != null) {
                responder.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + requester.m_7755_().getString() + " became soulbound. Binding failed.")).m_130940_(ChatFormatting.RED));
                requester.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou became soulbound. Request failed.").m_130940_(ChatFormatting.RED));
                return;
            }
            if (requestedRole.equals(WARD_ROLE)) {
                SoulbindManager.setPlayerRole(requester, WARD_ROLE);
                SoulbindManager.setPlayerRole(responder, GUARDIAN_ROLE);
                SoulbindManager.bindPlayers(responder, requester, true, false);
                SoulbindManager.checkAndOpenAbilityTypeScreen(responder, AbilityRole.GUARDIAN);
                SoulbindManager.checkAndOpenAbilityTypeScreen(requester, AbilityRole.WARD);
                return;
            }
            if (requestedRole.equals(GUARDIAN_ROLE)) {
                SoulbindManager.setPlayerRole(requester, GUARDIAN_ROLE);
                SoulbindManager.setPlayerRole(responder, WARD_ROLE);
                SoulbindManager.bindPlayers(requester, responder, true, false);
                SoulbindManager.checkAndOpenAbilityTypeScreen(requester, AbilityRole.GUARDIAN);
                SoulbindManager.checkAndOpenAbilityTypeScreen(responder, AbilityRole.WARD);
                return;
            }
            responder.m_213846_((Component)Component.m_237113_((String)("\u00a7cInvalid role specified in request: " + requestedRole)).m_130940_(ChatFormatting.RED));
            requester.m_213846_((Component)Component.m_237113_((String)"\u00a7cYour request had an invalid role.").m_130940_(ChatFormatting.RED));
            return;
        }
        responder.m_213846_((Component)Component.m_237113_((String)("\u00a7eYou denied the request from " + (requester != null ? requester.m_7755_().getString() : "an unknown player") + ".")).m_130940_(ChatFormatting.YELLOW));
        if (requester == null) return;
        requester.m_213846_((Component)Component.m_237113_((String)("\u00a7c" + responder.m_7755_().getString() + " denied your soulbind request.")).m_130940_(ChatFormatting.RED));
    }

    private static void checkAndOpenAbilityTypeScreen(ServerPlayer player, AbilityRole role) {
        if (player == null) {
            return;
        }
        Collection types = IKindredSoulsAPI.getInstance().getAbilityRegistry().getTypesForRole(role).stream().filter(type -> AbilityConfig.isAbilityEnabled(type.getId())).collect(Collectors.toList());
        if (types.size() <= 1) {
            IAbilityType defaultType = types.stream().findFirst().orElse(IKindredSoulsAPI.getInstance().getAbilityRegistry().getDefaultTypeForRole(role));
            SoulbindManager.setPlayerAbilityType(player, defaultType.getId());
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7aYou have been assigned the \u00a7f" + defaultType.getDisplayName().getString() + "\u00a7a type.")).m_130940_(ChatFormatting.GREEN));
        } else {
            List<S2C_OpenAbilityTypeScreenPacket.AbilityTypeData> typeData = types.stream().map(type -> new S2C_OpenAbilityTypeScreenPacket.AbilityTypeData(type.getId(), type.getDisplayName(), type.getDescription(), type.getLore(), type.getIconTexture())).collect(Collectors.toList());
            PacketRegistry.sendToPlayer(player, new S2C_OpenAbilityTypeScreenPacket(role, typeData));
            KindredSoulsMod.LOGGER.debug("Sending OpenAbilityTypeScreen packet to {} for role {}", (Object)player.m_7755_().getString(), (Object)role);
        }
    }

    public static void openCombinedRequestScreen(ServerPlayer player) {
        Map<UUID, String> outgoing;
        UUID playerUUID = player.m_20148_();
        ArrayList<RequestData> dataList = new ArrayList<RequestData>();
        if (serverInstance == null) {
            KindredSoulsMod.LOGGER.error("Server instance is null in openCombinedRequestScreen for player {}", (Object)player.m_7755_().getString());
            return;
        }
        Map<UUID, String> incoming = pendingRequests.get(playerUUID);
        if (incoming != null) {
            incoming.forEach((requesterUUID, role) -> {
                ServerPlayer requester = serverInstance.m_6846_().m_11259_(requesterUUID);
                String requesterName = requester != null ? requester.m_7755_().getString() : "Offline Player";
                dataList.add(new RequestData((UUID)requesterUUID, requesterName, (String)role, false));
            });
        }
        if ((outgoing = outgoingRequests.get(playerUUID)) != null) {
            outgoing.forEach((targetUUID, role) -> {
                ServerPlayer target = serverInstance.m_6846_().m_11259_(targetUUID);
                String targetName = target != null ? target.m_7755_().getString() : "Offline Player";
                dataList.add(new RequestData((UUID)targetUUID, targetName, (String)role, true));
            });
        }
        dataList.sort((r1, r2) -> {
            if (r1.isOutgoing() && !r2.isOutgoing()) {
                return 1;
            }
            if (!r1.isOutgoing() && r2.isOutgoing()) {
                return -1;
            }
            return r1.getOtherPlayerName().compareToIgnoreCase(r2.getOtherPlayerName());
        });
        HashMap<UUID, UUID> allSoulbinds = new HashMap<UUID, UUID>();
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null) {
            Map<UUID, UUID> pairs = data.getBoundPairs();
            pairs.forEach((ward, guardian) -> {
                allSoulbinds.put((UUID)guardian, (UUID)ward);
                allSoulbinds.put((UUID)ward, (UUID)guardian);
            });
        }
        PacketRegistry.sendToPlayer(player, new S2C_OpenRequestScreenPacket(dataList, allSoulbinds));
    }

    public static void handlePlayerLogout(UUID playerUUID) {
        Map<UUID, String> outgoing;
        if (serverInstance == null) {
            KindredSoulsMod.LOGGER.error("Server instance is null during handlePlayerLogout for {}", (Object)playerUUID);
            return;
        }
        Map<UUID, String> incoming = pendingRequests.remove(playerUUID);
        if (incoming != null) {
            for (UUID senderUUID : incoming.keySet()) {
                ServerPlayer sender;
                Map<UUID, String> senderOutgoing = outgoingRequests.get(senderUUID);
                if (senderOutgoing != null) {
                    senderOutgoing.remove(playerUUID);
                    if (senderOutgoing.isEmpty()) {
                        outgoingRequests.remove(senderUUID);
                    }
                }
                if ((sender = serverInstance.m_6846_().m_11259_(senderUUID)) == null) continue;
                sender.m_213846_((Component)Component.m_237113_((String)"\u00a7eYour soulbind request target logged out.").m_130940_(ChatFormatting.YELLOW));
            }
        }
        if ((outgoing = outgoingRequests.remove(playerUUID)) != null) {
            for (UUID targetUUID : outgoing.keySet()) {
                ServerPlayer target;
                Map<UUID, String> targetIncoming = pendingRequests.get(targetUUID);
                if (targetIncoming != null) {
                    targetIncoming.remove(playerUUID);
                    if (targetIncoming.isEmpty()) {
                        pendingRequests.remove(targetUUID);
                    }
                }
                if ((target = serverInstance.m_6846_().m_11259_(targetUUID)) == null) continue;
                target.m_213846_((Component)Component.m_237113_((String)"\u00a7eA soulbind request you received was cancelled (sender logged out).").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    public static void sendUpdatedSoulbindsToAllClients() {
        if (serverInstance == null) {
            return;
        }
        HashMap<UUID, UUID> allSoulbinds = new HashMap<UUID, UUID>();
        SoulbindSaveData data = SoulbindManager.getSaveData();
        if (data != null) {
            Map<UUID, UUID> pairs = data.getBoundPairs();
            pairs.forEach((ward, guardian) -> {
                allSoulbinds.put((UUID)guardian, (UUID)ward);
                allSoulbinds.put((UUID)ward, (UUID)guardian);
            });
        }
        PacketRegistry.sendToAll(new S2C_UpdatePlayerSoulbindsPacket(allSoulbinds));
    }

    public static void handleSoulbindCommand(Entity senderEntity, Entity targetEntity, boolean twoWay) {
        ServerPlayer sender;
        block6: {
            block5: {
                if (!(senderEntity instanceof ServerPlayer)) break block5;
                sender = (ServerPlayer)senderEntity;
                if (targetEntity instanceof ServerPlayer) break block6;
            }
            if (senderEntity != null) {
                senderEntity.m_213846_((Component)Component.m_237113_((String)"\u00a7cBoth source and target must be players.").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        ServerPlayer target = (ServerPlayer)targetEntity;
        if (sender.equals((Object)target)) {
            sender.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou cannot soulbind to yourself.").m_130940_(ChatFormatting.RED));
            return;
        }
        SoulbindManager.setPlayerRole(sender, GUARDIAN_ROLE);
        SoulbindManager.setPlayerRole(target, WARD_ROLE);
        SoulbindManager.bindPlayers(sender, target, true, twoWay);
        SoulbindManager.checkAndOpenAbilityTypeScreen(sender, AbilityRole.GUARDIAN);
        SoulbindManager.checkAndOpenAbilityTypeScreen(target, AbilityRole.WARD);
    }

    public static void handleUnbindCommand(Entity senderEntity) {
        if (!(senderEntity instanceof ServerPlayer)) {
            if (senderEntity != null) {
                senderEntity.m_213846_((Component)Component.m_237113_((String)"\u00a7cOnly players can unbind.").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        ServerPlayer sender = (ServerPlayer)senderEntity;
        SoulbindManager.unbindPlayer(sender);
    }
}

