/*
 * Decompiled with CFR 0.152.
 */
package net.sapphic.kindredsouls.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sapphic.kindredsouls.api.AbilityRole;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.config.AbilityConfig;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.S2C_OpenAbilityTypeScreenPacket;
import com.sapphic.kindredsouls.network.S2C_OpenRoleScreenPacket;
import com.sapphic.kindredsouls.soulbind.SoulbindManager;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GuiCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gui").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"role").executes(context -> GuiCommand.openRoleScreen(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82127_((String)"request").executes(context -> GuiCommand.openRequestScreen(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82127_((String)"ability").then(Commands.m_82129_((String)"role", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"GUARDIAN", "WARD"}, (SuggestionsBuilder)builder)).executes(context -> GuiCommand.openAbilityScreen(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"role")))));
        event.getDispatcher().register(command);
    }

    private static int openRoleScreen(ServerPlayer player) {
        PacketRegistry.sendToPlayer(player, new S2C_OpenRoleScreenPacket());
        player.m_213846_((Component)Component.m_237113_((String)"Opening Role Selection GUI..."));
        return 1;
    }

    private static int openRequestScreen(ServerPlayer player) {
        SoulbindManager.openCombinedRequestScreen(player);
        player.m_213846_((Component)Component.m_237113_((String)"Opening Request GUI..."));
        return 1;
    }

    private static int openAbilityScreen(ServerPlayer player, String roleStr) {
        AbilityRole role;
        try {
            role = AbilityRole.valueOf(roleStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.m_213846_((Component)Component.m_237113_((String)"Invalid role. Use GUARDIAN or WARD."));
            return 0;
        }
        Collection types = IKindredSoulsAPI.getInstance().getAbilityRegistry().getTypesForRole(role).stream().filter(type -> AbilityConfig.isAbilityEnabled(type.getId())).collect(Collectors.toList());
        List<S2C_OpenAbilityTypeScreenPacket.AbilityTypeData> typeData = types.stream().map(type -> new S2C_OpenAbilityTypeScreenPacket.AbilityTypeData(type.getId(), type.getDisplayName(), type.getDescription(), type.getLore(), type.getIconTexture())).collect(Collectors.toList());
        PacketRegistry.sendToPlayer(player, new S2C_OpenAbilityTypeScreenPacket(role, typeData));
        player.m_213846_((Component)Component.m_237113_((String)("Opening Ability Selection GUI for " + String.valueOf((Object)role) + "...")));
        return 1;
    }
}

