/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.soulbind;

import com.mojang.authlib.GameProfile;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.S2C_UpdateSoulmateDataPacket;
import com.sapphic.kindredsouls.soulbind.SoulbindManager;
import com.sapphic.kindredsouls.soulbind.SoulbindSaveData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sapphic.kindredsouls.KindredSoulsMod;

@Mod.EventBusSubscriber(modid="kindred_souls")
public class SoulbindEvents {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        SoulbindManager.setServerInstance(event.getServer());
        KindredSoulsMod.LOGGER.info("SoulbindManager server instance set.");
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            SoulbindManager.sendUpdatedSoulbindsToAllClients();
            KindredSoulsMod.LOGGER.info("Player {} logged in. Sending soulbind data.", (Object)player.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof ServerPlayer && !event.player.m_9236_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.player;
            if (player.f_19797_ % 20 != 0) {
                return;
            }
            String playerRole = SoulbindManager.getPlayerRole(player);
            if (playerRole.equals("UNASSIGNED")) {
                if (player.getPersistentData().m_128471_("kindredsouls_was_bound")) {
                    PacketRegistry.sendToPlayer(new S2C_UpdateSoulmateDataPacket("", "UNASSIGNED"), player);
                    player.getPersistentData().m_128473_("kindredsouls_was_bound");
                }
                return;
            }
            player.getPersistentData().m_128379_("kindredsouls_was_bound", true);
            UUID soulmateUUID = SoulbindManager.getSoulmate(player);
            if (soulmateUUID != null) {
                ServerPlayer soulmate = player.m_20194_().m_6846_().m_11259_(soulmateUUID);
                if (soulmate != null) {
                    String soulmateRole = SoulbindManager.getPlayerRole(soulmate);
                    BlockPos pos = soulmate.m_20183_();
                    String dim = SoulbindEvents.getDimensionName((ResourceKey<Level>)soulmate.m_9236_().m_46472_());
                    String name = soulmate.m_7755_().getString();
                    PacketRegistry.sendToPlayer(new S2C_UpdateSoulmateDataPacket(name, dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), soulmateRole), player);
                } else {
                    SoulbindSaveData data = SoulbindManager.getSaveData((Entity)player);
                    String soulmateRole = data != null ? data.getPlayerRoles().getOrDefault(soulmateUUID, "UNASSIGNED") : "UNASSIGNED";
                    String name = player.m_20194_().m_129927_().m_11002_(soulmateUUID).map(GameProfile::getName).orElse("Soulmate");
                    PacketRegistry.sendToPlayer(new S2C_UpdateSoulmateDataPacket(name, soulmateRole), player);
                }
            }
        }
    }

    private static String getDimensionName(ResourceKey<Level> key) {
        if (key == Level.f_46428_) {
            return "Overworld";
        }
        if (key == Level.f_46429_) {
            return "The Nether";
        }
        if (key == Level.f_46430_) {
            return "The End";
        }
        Object path = key.m_135782_().m_135815_();
        path = ((String)path).substring(0, 1).toUpperCase() + ((String)path).substring(1).replace("_", " ");
        return path;
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        SoulbindManager.handlePlayerLogout(event.getEntity().m_20148_());
        KindredSoulsMod.LOGGER.info("Player {} logged out. Cleaning up requests.", (Object)event.getEntity().m_7755_().getString());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        float originalDamage;
        if (event.getEntity().m_9236_().m_5776_() || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer damagedPlayer = (ServerPlayer)event.getEntity();
        if (damagedPlayer == null || damagedPlayer.m_20194_() == null) {
            return;
        }
        if (damagedPlayer.m_19880_().contains("kindredsouls_damaging")) {
            damagedPlayer.m_19880_().remove("kindredsouls_damaging");
            return;
        }
        SoulbindSaveData data = SoulbindManager.getSaveData((Entity)damagedPlayer);
        String role = SoulbindManager.getPlayerRole(damagedPlayer);
        UUID soulmateUUID = SoulbindManager.getSoulmate(damagedPlayer);
        if (data == null || soulmateUUID == null || role.equals("UNASSIGNED")) {
            return;
        }
        ServerPlayer soulmate = damagedPlayer.m_20194_().m_6846_().m_11259_(soulmateUUID);
        if (soulmate == null || soulmate.m_21224_()) {
            return;
        }
        UUID wardUUID = role.equals("WARD") ? damagedPlayer.m_20148_() : soulmateUUID;
        boolean isTwoWay = data.getIsTwoWay().getOrDefault(wardUUID, false);
        float damageToPlayer = originalDamage = event.getAmount();
        float damageToSoulmate = 0.0f;
        if (role.equals("WARD")) {
            damageToPlayer = originalDamage * 0.5f;
            damageToSoulmate = originalDamage * 0.5f;
        } else if (role.equals("GUARDIAN") && isTwoWay) {
            damageToPlayer = originalDamage * 0.5f;
            damageToSoulmate = originalDamage * 0.5f;
        }
        if (damageToSoulmate > 0.0f) {
            soulmate.m_19880_().add("kindredsouls_damaging");
            soulmate.m_6469_(event.getSource(), damageToSoulmate);
        }
        event.setAmount(damageToPlayer);
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        if (event.getEntity().m_9236_().m_5776_() || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer healedPlayer = (ServerPlayer)event.getEntity();
        if (healedPlayer == null || healedPlayer.m_20194_() == null) {
            return;
        }
        if (healedPlayer.m_19880_().contains("kindredsouls_healing")) {
            healedPlayer.m_19880_().remove("kindredsouls_healing");
            return;
        }
        SoulbindSaveData data = SoulbindManager.getSaveData((Entity)healedPlayer);
        String role = SoulbindManager.getPlayerRole(healedPlayer);
        UUID soulmateUUID = SoulbindManager.getSoulmate(healedPlayer);
        if (data == null || soulmateUUID == null || role.equals("UNASSIGNED")) {
            return;
        }
        ServerPlayer soulmate = healedPlayer.m_20194_().m_6846_().m_11259_(soulmateUUID);
        if (soulmate == null || soulmate.m_21224_()) {
            return;
        }
        UUID wardUUID = role.equals("WARD") ? healedPlayer.m_20148_() : soulmateUUID;
        boolean isTwoWay = data.getIsTwoWay().getOrDefault(wardUUID, false);
        float originalHeal = event.getAmount();
        float healToSoulmate = 0.0f;
        if (role.equals("WARD")) {
            healToSoulmate = originalHeal * 0.5f;
        } else if (role.equals("GUARDIAN") && isTwoWay) {
            healToSoulmate = originalHeal * 0.5f;
        }
        if (healToSoulmate > 0.0f && soulmate.m_21223_() < soulmate.m_21233_()) {
            soulmate.m_19880_().add("kindredsouls_healing");
            soulmate.m_5634_(healToSoulmate);
        }
    }
}

