/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.client.gui;

import com.sapphic.kindredsouls.client.gui.PlayerSelectionList;
import com.sapphic.kindredsouls.network.C2S_RespondToRequestPacket;
import com.sapphic.kindredsouls.network.C2S_SendRequestPacket;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.RequestData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RequestScreen
extends Screen {
    private final List<RequestData> requests;
    private final Map<UUID, UUID> boundPlayers;
    private EditBox searchPlayerField;
    private PlayerSelectionList playerSelectionList;
    private Checkbox hideBoundCheckbox;
    private Button sendGuardianRequestButton;
    private Button sendWardRequestButton;
    private UUID selectedTargetPlayerUUID;
    private String selectedTargetPlayerName;
    private int requestListTop;
    private int requestListLeft;
    private int requestListWidth;
    private int requestListHeight;
    private final int requestListEntryHeight = 24;
    private int requestListScrollOffset = 0;

    public RequestScreen(List<RequestData> requests, Map<UUID, UUID> boundPlayers) {
        super((Component)Component.m_237115_((String)"gui.kindred_souls.request_screen.title"));
        this.requests = requests;
        this.boundPlayers = boundPlayers;
        this.requests.sort((a, b) -> Boolean.compare(a.isOutgoing(), b.isOutgoing()));
    }

    public boolean isPlayerBound(UUID playerUUID) {
        return this.boundPlayers.containsKey(playerUUID);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        int screenCenterX = this.f_96543_ / 2;
        int currentY = 20;
        int leftPanelWidth = 120;
        int leftPanelX = screenCenterX - leftPanelWidth - 10;
        int elementX = leftPanelX + 5;
        int elementWidth = leftPanelWidth - 10;
        this.searchPlayerField = new EditBox(this.f_96547_, elementX, currentY += 12, elementWidth, 18, (Component)Component.m_237115_((String)"gui.kindred_souls.search_player"));
        this.m_142416_((GuiEventListener)this.searchPlayerField);
        this.hideBoundCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(elementX, currentY += 20, elementWidth, 18, (Component)Component.m_237115_((String)"gui.kindred_souls.hide_bound"), true){

            public void m_5691_() {
                super.m_5691_();
                if (RequestScreen.this.playerSelectionList != null) {
                    RequestScreen.this.playerSelectionList.setHideBoundPlayers(this.m_93840_());
                }
            }
        });
        int listBottom = this.f_96544_ - 50;
        int listHeight = listBottom - (currentY += 20);
        this.playerSelectionList = new PlayerSelectionList(this, this.f_96541_, elementWidth, listHeight, currentY, listBottom, 20, elementX);
        this.m_142416_((GuiEventListener)this.playerSelectionList);
        this.searchPlayerField.m_94151_(this.playerSelectionList::setSearchText);
        this.hideBoundCheckbox.m_5691_();
        currentY = this.playerSelectionList.getBottom() + 5;
        int buttonWidth = elementWidth / 2 - 2;
        this.sendGuardianRequestButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Request Guardian"), button -> this.sendRequest("GUARDIAN")).m_252987_(elementX, currentY, buttonWidth, 20).m_253136_());
        this.sendWardRequestButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Request Ward"), button -> this.sendRequest("WARD")).m_252987_(elementX + buttonWidth + 4, currentY, buttonWidth, 20).m_253136_());
        this.sendGuardianRequestButton.f_93623_ = false;
        this.sendWardRequestButton.f_93623_ = false;
        int rightPanelWidth = 200;
        this.requestListLeft = screenCenterX + 10;
        this.requestListTop = 32;
        this.requestListWidth = rightPanelWidth;
        this.requestListHeight = this.f_96544_ - this.requestListTop - 35;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20).m_253136_());
        this.updateSendRequestButtons();
    }

    public void onPlayerSelectedForRequest(String playerName, UUID playerUUID) {
        this.selectedTargetPlayerName = playerName;
        this.selectedTargetPlayerUUID = playerUUID;
        this.updateSendRequestButtons();
    }

    private void updateSendRequestButtons() {
        boolean playerSelected = this.selectedTargetPlayerUUID != null;
        this.sendGuardianRequestButton.f_93623_ = playerSelected && !this.isPlayerBound(this.selectedTargetPlayerUUID);
        this.sendWardRequestButton.f_93623_ = playerSelected && !this.isPlayerBound(this.selectedTargetPlayerUUID);
    }

    private void sendRequest(String role) {
        if (this.selectedTargetPlayerUUID == null || this.selectedTargetPlayerName == null || this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cPlease select a player.").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        if (this.selectedTargetPlayerUUID.equals(this.f_96541_.f_91074_.m_20148_())) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou cannot send a request to yourself.").m_130940_(ChatFormatting.RED));
            return;
        }
        PacketRegistry.sendToServer(new C2S_SendRequestPacket(this.selectedTargetPlayerUUID, role));
        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7aSent request to " + this.selectedTargetPlayerName + " to be their " + role + ".")).m_130940_(ChatFormatting.GREEN));
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        int screenCenterX = this.f_96543_ / 2;
        int leftPanelWidth = 120;
        int leftPanelX = screenCenterX - leftPanelWidth - 10;
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.kindred_souls.request_screen.send_title"), leftPanelX + leftPanelWidth / 2, 20, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.kindred_souls.request_screen.list_title"), this.requestListLeft + this.requestListWidth / 2, 20, 0xFFFFFF);
        guiGraphics.m_280509_(this.requestListLeft, this.requestListTop, this.requestListLeft + this.requestListWidth, this.requestListTop + this.requestListHeight, 0x50000000);
        guiGraphics.m_280168_().m_85836_();
        double scale = this.f_96541_.m_91268_().m_85449_();
        guiGraphics.m_280588_((int)((double)this.requestListLeft * scale), (int)((double)this.requestListTop * scale), (int)((double)(this.requestListLeft + this.requestListWidth) * scale), (int)((double)(this.requestListTop + this.requestListHeight) * scale));
        int yPos = this.requestListTop;
        int maxVisibleIndex = this.requestListScrollOffset + this.requestListHeight / 24;
        for (int i = this.requestListScrollOffset; i < this.requests.size() && i < maxVisibleIndex; ++i) {
            MutableComponent requestText;
            RequestData request = this.requests.get(i);
            int entryY = yPos + (i - this.requestListScrollOffset) * 24;
            guiGraphics.m_280509_(this.requestListLeft + 2, entryY + 1, this.requestListLeft + this.requestListWidth - 2, entryY + 24 - 1, 0x30FFFFFF);
            if (request.isOutgoing()) {
                requestText = Component.m_237113_((String)"To: ").m_7220_((Component)Component.m_237113_((String)request.getOtherPlayerName()).m_130940_(ChatFormatting.YELLOW)).m_130946_(" (" + request.getRequestedRole() + ")").m_130940_(ChatFormatting.GRAY);
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280614_(this.f_96547_, (Component)requestText, this.requestListLeft + 5, entryY + (24 - 9) / 2, 0xFFFFFF, false);
                continue;
            }
            requestText = Component.m_237113_((String)"From: ").m_7220_((Component)Component.m_237113_((String)request.getOtherPlayerName()).m_130940_(ChatFormatting.GOLD)).m_130946_(" wants to be your " + request.getRequestedRole()).m_130940_(ChatFormatting.AQUA);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280614_(this.f_96547_, (Component)requestText, this.requestListLeft + 5, entryY + (24 - 9) / 2, 0xFFFFFF, false);
            int buttonWidthSmall = 40;
            int buttonPadding = 2;
            int acceptX = this.requestListLeft + this.requestListWidth - buttonWidthSmall - buttonPadding;
            int denyX = acceptX - buttonWidthSmall - buttonPadding;
            Button acceptButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.kindred_souls.request.accept"), b -> {
                PacketRegistry.sendToServer(new C2S_RespondToRequestPacket(request.getRequestId(), true));
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aAccepted request!").m_130940_(ChatFormatting.GREEN));
                this.m_7379_();
            }).m_252987_(acceptX, entryY + 2, buttonWidthSmall, 20).m_253136_();
            Button denyButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.kindred_souls.request.deny"), b -> {
                PacketRegistry.sendToServer(new C2S_RespondToRequestPacket(request.getRequestId(), false));
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eDenied request.").m_130940_(ChatFormatting.YELLOW));
                this.m_7379_();
            }).m_252987_(denyX, entryY + 2, buttonWidthSmall, 20).m_253136_();
            this.m_142416_((GuiEventListener)acceptButton);
            this.m_142416_((GuiEventListener)denyButton);
        }
        guiGraphics.m_280618_();
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.playerSelectionList != null && this.playerSelectionList.m_5953_(mouseX, mouseY)) {
            return this.playerSelectionList.m_6050_(mouseX, mouseY, delta);
        }
        if (mouseX >= (double)this.requestListLeft && mouseX < (double)(this.requestListLeft + this.requestListWidth) && mouseY >= (double)this.requestListTop && mouseY < (double)(this.requestListTop + this.requestListHeight)) {
            int maxScroll = Math.max(0, this.requests.size() - this.requestListHeight / 24);
            if (delta < 0.0) {
                this.requestListScrollOffset = Math.min(maxScroll, this.requestListScrollOffset + 1);
            } else if (delta > 0.0) {
                this.requestListScrollOffset = Math.max(0, this.requestListScrollOffset - 1);
            }
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_6915_();
        }
        super.m_7379_();
    }
}

