/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.client.gui.RequestScreen;
import com.sapphic.kindredsouls.network.RequestData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2C_OpenRequestScreenPacket {
    private final List<RequestData> requests;
    private final Map<UUID, UUID> boundPlayers;

    public S2C_OpenRequestScreenPacket(List<RequestData> requests, Map<UUID, UUID> boundPlayers) {
        this.requests = requests;
        this.boundPlayers = boundPlayers;
    }

    public static void encode(S2C_OpenRequestScreenPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.requests.size());
        for (RequestData requestData : msg.requests) {
            RequestData.encode(requestData, buf);
        }
        buf.writeInt(msg.boundPlayers.size());
        for (Map.Entry entry : msg.boundPlayers.entrySet()) {
            buf.m_130077_((UUID)entry.getKey());
            buf.m_130077_((UUID)entry.getValue());
        }
    }

    public static S2C_OpenRequestScreenPacket decode(FriendlyByteBuf buf) {
        int requestSize = buf.readInt();
        ArrayList<RequestData> requests = new ArrayList<RequestData>(requestSize);
        for (int i = 0; i < requestSize; ++i) {
            requests.add(RequestData.decode(buf));
        }
        int boundSize = buf.readInt();
        HashMap<UUID, UUID> boundPlayers = new HashMap<UUID, UUID>(boundSize);
        for (int i = 0; i < boundSize; ++i) {
            UUID player = buf.m_130259_();
            UUID soulmate = buf.m_130259_();
            boundPlayers.put(player, soulmate);
        }
        return new S2C_OpenRequestScreenPacket(requests, boundPlayers);
    }

    public static void handle(S2C_OpenRequestScreenPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new RequestScreen(msg.requests, msg.boundPlayers))));
        ctx.get().setPacketHandled(true);
    }
}

