/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.api;

import com.sapphic.kindredsouls.api.AbilityRole;
import com.sapphic.kindredsouls.api.AbilityType;
import com.sapphic.kindredsouls.api.IAbilityType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.sapphic.kindredsouls.KindredSoulsMod;

public class AbilityRegistry {
    public static final IAbilityType DEFAULT_GUARDIAN = new AbilityType(new ResourceLocation("kindred_souls", "default_guardian"), AbilityRole.GUARDIAN, (Component)Component.m_237115_((String)"ability.kindred_souls.default_guardian.name"), (Component)Component.m_237115_((String)"ability.kindred_souls.default_guardian.desc"), (Component)Component.m_237119_(), new ResourceLocation("minecraft", "textures/item/totem_of_undying.png"));
    public static final IAbilityType DEFAULT_WARD = new AbilityType(new ResourceLocation("kindred_souls", "default_ward"), AbilityRole.WARD, (Component)Component.m_237115_((String)"ability.kindred_souls.default_ward.name"), (Component)Component.m_237115_((String)"ability.kindred_souls.default_ward.desc"), (Component)Component.m_237119_(), new ResourceLocation("minecraft", "textures/item/totem_of_undying.png"));
    private final Map<ResourceLocation, IAbilityType> registry = new LinkedHashMap<ResourceLocation, IAbilityType>();

    public void registerDefaults() {
        this.register(DEFAULT_GUARDIAN);
        this.register(DEFAULT_WARD);
    }

    public void register(IAbilityType type) {
        if (this.registry.containsKey(type.getId())) {
            KindredSoulsMod.LOGGER.warn("Duplicate ability type registration: {}", (Object)type.getId());
            return;
        }
        this.registry.put(type.getId(), type);
        KindredSoulsMod.LOGGER.info("Registered ability type: {}", (Object)type.getId());
    }

    public IAbilityType getType(ResourceLocation id) {
        return this.registry.get(id);
    }

    public Collection<IAbilityType> getTypesForRole(AbilityRole role) {
        return this.registry.values().stream().filter(type -> type.getRole() == role).collect(Collectors.toList());
    }

    public IAbilityType getDefaultTypeForRole(AbilityRole role) {
        return role == AbilityRole.GUARDIAN ? DEFAULT_GUARDIAN : DEFAULT_WARD;
    }
}

