/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.api.AbilityRole;
import com.sapphic.kindredsouls.client.ClientPacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2C_OpenAbilityTypeScreenPacket {
    private final AbilityRole role;
    private final List<AbilityTypeData> abilityTypes;

    public S2C_OpenAbilityTypeScreenPacket(AbilityRole role, List<AbilityTypeData> abilityTypes) {
        this.role = role;
        this.abilityTypes = abilityTypes;
    }

    public AbilityRole getRole() {
        return this.role;
    }

    public List<AbilityTypeData> getAbilityTypes() {
        return this.abilityTypes;
    }

    public static void encode(S2C_OpenAbilityTypeScreenPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.role);
        buf.m_236828_(msg.abilityTypes, (byteBuf, data) -> data.encode((FriendlyByteBuf)byteBuf));
    }

    public static S2C_OpenAbilityTypeScreenPacket decode(FriendlyByteBuf buf) {
        AbilityRole role = (AbilityRole)buf.m_130066_(AbilityRole.class);
        List types = (List)buf.m_236838_(ArrayList::new, AbilityTypeData::decode);
        return new S2C_OpenAbilityTypeScreenPacket(role, types);
    }

    public static void handle(S2C_OpenAbilityTypeScreenPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleOpenAbilityTypeScreen(msg)));
        ctx.get().setPacketHandled(true);
    }

    public static class AbilityTypeData {
        private final ResourceLocation id;
        private final Component name;
        private final Component description;
        private final Component lore;
        private final ResourceLocation icon;

        public AbilityTypeData(ResourceLocation id, Component name, Component description, Component lore, ResourceLocation icon) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.lore = lore;
            this.icon = icon;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public Component getName() {
            return this.name;
        }

        public Component getDescription() {
            return this.description;
        }

        public Component getLore() {
            return this.lore;
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130085_(this.id);
            buf.m_130083_(this.name);
            buf.m_130083_(this.description);
            buf.m_130083_(this.lore);
            buf.m_130085_(this.icon);
        }

        public static AbilityTypeData decode(FriendlyByteBuf buf) {
            return new AbilityTypeData(buf.m_130281_(), buf.m_130238_(), buf.m_130238_(), buf.m_130238_(), buf.m_130281_());
        }
    }
}

