/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.client.ClientSoulbindData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2C_UpdatePlayerSoulbindsPacket {
    private final Map<UUID, UUID> boundPlayers;

    public S2C_UpdatePlayerSoulbindsPacket(Map<UUID, UUID> boundPlayers) {
        this.boundPlayers = boundPlayers;
    }

    public static void encode(S2C_UpdatePlayerSoulbindsPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.boundPlayers.size());
        for (Map.Entry<UUID, UUID> entry : msg.boundPlayers.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130077_(entry.getValue());
        }
    }

    public static S2C_UpdatePlayerSoulbindsPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<UUID, UUID> boundPlayers = new HashMap<UUID, UUID>(size);
        for (int i = 0; i < size; ++i) {
            UUID player = buf.m_130259_();
            UUID soulmate = buf.m_130259_();
            boundPlayers.put(player, soulmate);
        }
        return new S2C_UpdatePlayerSoulbindsPacket(boundPlayers);
    }

    public static void handle(S2C_UpdatePlayerSoulbindsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSoulbindData.setSoulbindMap(msg.boundPlayers)));
        ctx.get().setPacketHandled(true);
    }
}

