/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.soulbind;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class SoulbindSaveData
extends SavedData {
    public static final String DATA_NAME = "kindred_souls_soulbind_data";
    private Map<UUID, UUID> boundPairs = new HashMap<UUID, UUID>();
    private Map<UUID, Boolean> isTwoWay = new HashMap<UUID, Boolean>();
    private Map<UUID, String> playerRoles = new HashMap<UUID, String>();
    private Map<UUID, String> playerAbilityTypes = new HashMap<UUID, String>();

    public SoulbindSaveData() {
    }

    public SoulbindSaveData(CompoundTag tag) {
        SoulbindSaveData.load(tag);
    }

    public Map<UUID, UUID> getBoundPairs() {
        return this.boundPairs;
    }

    public Map<UUID, Boolean> getIsTwoWay() {
        return this.isTwoWay;
    }

    public Map<UUID, String> getPlayerRoles() {
        return this.playerRoles;
    }

    public Map<UUID, String> getPlayerAbilityTypes() {
        return this.playerAbilityTypes;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag pairsList = new ListTag();
        for (Map.Entry<UUID, UUID> entry : this.boundPairs.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("SourceUUID", entry.getKey().toString());
            entryTag.m_128359_("TargetUUID", entry.getValue().toString());
            entryTag.m_128379_("IsTwoWay", this.isTwoWay.getOrDefault(entry.getKey(), false).booleanValue());
            pairsList.add((Object)entryTag);
        }
        tag.m_128365_("SoulbindPairs", (Tag)pairsList);
        ListTag rolesList = new ListTag();
        for (Map.Entry<UUID, String> entry : this.playerRoles.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("UUID", entry.getKey().toString());
            entryTag.m_128359_("Role", entry.getValue());
            String type = this.playerAbilityTypes.get(entry.getKey());
            if (type != null) {
                entryTag.m_128359_("AbilityType", type);
            }
            rolesList.add((Object)entryTag);
        }
        tag.m_128365_("PlayerRoles", (Tag)rolesList);
        return tag;
    }

    public static SoulbindSaveData load(CompoundTag tag) {
        SoulbindSaveData data = new SoulbindSaveData();
        ListTag pairsList = tag.m_128437_("SoulbindPairs", 10);
        for (int i = 0; i < pairsList.size(); ++i) {
            CompoundTag entryTag = pairsList.m_128728_(i);
            try {
                UUID source = UUID.fromString(entryTag.m_128461_("SourceUUID"));
                UUID target = UUID.fromString(entryTag.m_128461_("TargetUUID"));
                boolean twoWay = entryTag.m_128471_("IsTwoWay");
                data.boundPairs.put(source, target);
                data.isTwoWay.put(source, twoWay);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to load soulbind UUID: " + e.getMessage());
            }
        }
        ListTag rolesList = tag.m_128437_("PlayerRoles", 10);
        for (int i = 0; i < rolesList.size(); ++i) {
            CompoundTag entryTag = rolesList.m_128728_(i);
            try {
                UUID uuid = UUID.fromString(entryTag.m_128461_("UUID"));
                String role = entryTag.m_128461_("Role");
                data.playerRoles.put(uuid, role);
                if (!entryTag.m_128425_("AbilityType", 8)) continue;
                data.playerAbilityTypes.put(uuid, entryTag.m_128461_("AbilityType"));
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to load player role UUID: " + e.getMessage());
            }
        }
        return data;
    }

    public static SoulbindSaveData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            DimensionDataStorage storage = serverLevel.m_8895_();
            return (SoulbindSaveData)storage.m_164861_(SoulbindSaveData::load, SoulbindSaveData::new, DATA_NAME);
        }
        return new SoulbindSaveData();
    }
}

