/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls;

import com.sapphic.kindredsouls.KindredSoulsAPIImpl;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.config.AbilityConfig;
import com.sapphic.kindredsouls.config.KindredSoulsConfig;
import com.sapphic.kindredsouls.network.PacketRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.sapphic.kindredsouls.KindredSoulsMod;

@Mod.EventBusSubscriber(modid="kindred_souls", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModSetup {
    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PacketRegistry.register();
            AbilityConfig.init();
        });
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        KindredSoulsMod.LOGGER.info("Running post-setup task: Registering all abilities to config...");
        AbilityConfig.registerAllAbilities();
    }

    static {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)KindredSoulsConfig.COMMON_SPEC);
        KindredSoulsAPIImpl impl = new KindredSoulsAPIImpl();
        impl.getAbilityRegistry().registerDefaults();
        IKindredSoulsAPI.Holder.setInstance(impl);
        KindredSoulsMod.LOGGER.info("Kindred Souls API instance registered via ModSetup.");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(ModSetup.class);
        KindredSoulsMod.LOGGER.info("Manually registered ModSetup to the MOD event bus.");
    }
}

