/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.api;

import com.sapphic.kindredsouls.api.ISkill;
import com.sapphic.kindredsouls.api.ISkillUnlockCondition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.sapphic.kindredsouls.KindredSoulsMod;

public class SkillUnlockRegistry {
    public static final ISkillUnlockCondition DEFAULT_CONDITION = new ISkillUnlockCondition(){

        @Override
        public boolean canUnlock(ServerPlayer player, ISkill skill) {
            return true;
        }

        @Override
        public void applyCost(ServerPlayer player, ISkill skill) {
        }

        @Override
        public Component getCostDescription(ServerPlayer player, ISkill skill) {
            return Component.m_237113_((String)"Free");
        }
    };
    private final Map<ResourceLocation, ISkillUnlockCondition> registry = new ConcurrentHashMap<ResourceLocation, ISkillUnlockCondition>();

    public void register(ResourceLocation skillId, ISkillUnlockCondition condition) {
        if (this.registry.containsKey(skillId)) {
            KindredSoulsMod.LOGGER.warn("Duplicate skill unlock condition registration: {}", (Object)skillId);
        } else {
            this.registry.put(skillId, condition);
            KindredSoulsMod.LOGGER.info("Registered unlock condition for skill: {}", (Object)skillId);
        }
    }

    public ISkillUnlockCondition get(ResourceLocation skillId) {
        return this.registry.getOrDefault(skillId, DEFAULT_CONDITION);
    }
}

