/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sapphic.kindredsouls.client.gui.PlayerSelectionList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerEntry
extends ContainerObjectSelectionList.Entry<PlayerEntry> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final PlayerInfo playerInfo;
    private final UUID playerUUID;
    private final String playerName;
    private final PlayerSelectionList parentList;

    public PlayerEntry(PlayerSelectionList parentList, PlayerInfo playerInfo) {
        this.playerInfo = playerInfo;
        this.playerUUID = playerInfo.m_105312_().getId();
        String name = playerInfo.m_105312_().getName();
        this.playerName = name == null ? "Invalid Player" : name;
        this.parentList = parentList;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation skin = this.playerInfo.m_105337_();
        guiGraphics.m_280411_(skin, left + 2, top + 2, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.m_280411_(skin, left + 2, top + 2, 16, 16, 40.0f, 8.0f, 8, 8, 64, 64);
        Font font = this.minecraft.f_91062_;
        MutableComponent mutableComponent = Component.m_237113_((String)this.playerName);
        Objects.requireNonNull(this.minecraft.f_91062_);
        guiGraphics.m_280614_(font, (Component)mutableComponent, left + 22, top + (height - 9) / 2, 0xFFFFFF, false);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    public List<? extends NarratableEntry> m_142437_() {
        return ImmutableList.of((Object)new NarratableEntry(){

            public NarratableEntry.NarrationPriority m_142684_() {
                return NarratableEntry.NarrationPriority.HOVERED;
            }

            public void m_142291_(NarrationElementOutput output) {
            }
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.parentList.setSelected(this);
            return true;
        }
        return false;
    }
}

