/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.client.gui;

import com.sapphic.kindredsouls.client.gui.PlayerEntry;
import com.sapphic.kindredsouls.client.gui.RequestScreen;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerSelectionList
extends ContainerObjectSelectionList<PlayerEntry> {
    private final RequestScreen parentScreen;
    private List<PlayerEntry> originalEntries;
    private String lastSearchText = "";
    private boolean hideBoundPlayers = false;

    public PlayerSelectionList(RequestScreen parent, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, int x0) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.parentScreen = parent;
        this.f_93394_ = false;
        this.f_93393_ = x0;
        this.f_93392_ = x0 + width;
        this.updatePlayerList();
    }

    public void updatePlayerList() {
        if (this.f_93386_.m_91403_() != null && this.f_93386_.f_91074_ != null) {
            UUID selfUUID = this.f_93386_.f_91074_.m_20148_();
            this.originalEntries = this.f_93386_.m_91403_().m_105142_().stream().filter(playerInfo -> !playerInfo.m_105312_().getId().equals(selfUUID)).filter(playerInfo -> playerInfo.m_105312_() != null && playerInfo.m_105312_().getName() != null).map(playerInfo -> new PlayerEntry(this, (PlayerInfo)playerInfo)).collect(Collectors.toList());
        } else {
            this.originalEntries = List.of();
        }
        this.filterAndSortList();
    }

    public void setSearchText(String text) {
        this.lastSearchText = text == null ? "" : text.toLowerCase();
        this.filterAndSortList();
    }

    public void setHideBoundPlayers(boolean hide) {
        this.hideBoundPlayers = hide;
        this.filterAndSortList();
    }

    private void filterAndSortList() {
        this.m_93516_();
        if (this.originalEntries != null) {
            List<PlayerEntry> filtered = this.originalEntries.stream().filter(entry -> entry.getPlayerName() != null && entry.getPlayerName().toLowerCase().contains(this.lastSearchText)).filter(entry -> !this.hideBoundPlayers || !this.parentScreen.isPlayerBound(entry.getPlayerUUID())).sorted(Comparator.comparing(PlayerEntry::getPlayerName)).collect(Collectors.toList());
            filtered.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }
    }

    public int m_5759_() {
        return this.f_93388_ - (this.m_93518_() > 0 ? 18 : 10);
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    public void setSelected(PlayerEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            // empty if block
        }
    }
}

