/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sapphic.kindredsouls.network.C2S_UnlockSkillPacket;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.S2C_OpenSkillTreeScreenPacket;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.gui.screens.popup.YesNoPopup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillTreeScreen
extends Screen {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("minecraft:textures/gui/advancements/widgets.png");
    private static final ResourceLocation WINDOW_LOCATION = new ResourceLocation("minecraft:textures/gui/advancements/window.png");
    private final Map<ResourceLocation, AbilityTabWidget> tabs = Maps.newLinkedHashMap();
    private final Map<ResourceLocation, SkillWidget> skills = Maps.newHashMap();
    private AbilityTabWidget selectedTab;
    private double panX;
    private double panY;
    private boolean isPanning;
    private static final int SCREEN_WIDTH = 252;
    private static final int SCREEN_HEIGHT = 140;
    private static final int TAB_WIDTH = 28;
    private static final int TAB_HEIGHT = 32;
    private static final int SKILL_NODE_SIZE = 26;
    private static final int SKILL_X_SPACING = 38;
    private static final int SKILL_Y_SPACING = 30;

    /*
     * WARNING - void declaration
     */
    public SkillTreeScreen(List<S2C_OpenSkillTreeScreenPacket.AbilityTabData> tabData, List<S2C_OpenSkillTreeScreenPacket.SkillData> skillData, ResourceLocation selectedTabId) {
        super((Component)Component.m_237113_((String)"Skill Tree"));
        void var5_9;
        for (S2C_OpenSkillTreeScreenPacket.SkillData skillData2 : skillData) {
            this.skills.put(skillData2.id(), new SkillWidget(skillData2));
        }
        LinkedHashMap orderedTabs = Maps.newLinkedHashMap();
        for (S2C_OpenSkillTreeScreenPacket.AbilityTabData data : tabData) {
            orderedTabs.put(data.id(), new AbilityTabWidget(data, tab -> this.setSelectedTab((AbilityTabWidget)((Object)((Object)tab)), true)));
        }
        this.tabs.putAll(orderedTabs);
        AbilityTabWidget abilityTabWidget = this.tabs.get(selectedTabId);
        if (abilityTabWidget == null && !this.tabs.isEmpty()) {
            AbilityTabWidget abilityTabWidget2 = this.tabs.values().iterator().next();
        }
        this.selectedTab = var5_9;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        this.m_169413_();
        this.skills.values().forEach(x$0 -> {
            SkillWidget cfr_ignored_0 = (SkillWidget)this.m_142416_((GuiEventListener)x$0);
        });
        int x = (this.f_96543_ - 252) / 2 - 28 + 4;
        int y = (this.f_96544_ - 140) / 2;
        int i = 0;
        for (AbilityTabWidget tab : this.tabs.values()) {
            tab.m_252865_(x);
            tab.m_253211_(y + 32 * i);
            this.m_142416_((GuiEventListener)tab);
            ++i;
        }
        this.setSelectedTab(this.selectedTab, false);
    }

    private void setSelectedTab(AbilityTabWidget tab, boolean update) {
        if (tab == null) {
            return;
        }
        if (this.selectedTab != null) {
            this.selectedTab.setSelected(false);
        }
        this.selectedTab = tab;
        this.selectedTab.setSelected(true);
        this.panX = 0.0;
        this.panY = 0.0;
        this.updateWidgetVisibility();
    }

    private void updateWidgetVisibility() {
        if (this.selectedTab == null) {
            return;
        }
        ResourceLocation selectedId = this.selectedTab.tabData.id();
        for (SkillWidget widget : this.skills.values()) {
            widget.f_93624_ = widget.skill.parentTabId().equals((Object)selectedId);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int x = (this.f_96543_ - 252) / 2;
            int y = (this.f_96544_ - 140) / 2;
            if (mouseX > (double)x && mouseX < (double)(x + 252) && mouseY > (double)y && mouseY < (double)(y + 140)) {
                for (SkillWidget widget : this.skills.values()) {
                    if (!widget.f_93624_ || !widget.m_5953_(mouseX, mouseY)) continue;
                    return super.m_6375_(mouseX, mouseY, button);
                }
                this.isPanning = true;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isPanning = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isPanning) {
            int minX = 0;
            int maxX = 0;
            int minY = 0;
            int maxY = 0;
            boolean hasWidgets = false;
            for (SkillWidget w : this.skills.values()) {
                if (!w.f_93624_) continue;
                minX = Math.min(minX, w.skill.x());
                maxX = Math.max(maxX, w.skill.x());
                minY = Math.min(minY, w.skill.y());
                maxY = Math.max(maxY, w.skill.y());
                hasWidgets = true;
            }
            if (!hasWidgets) {
                return true;
            }
            int screenLeft = (this.f_96543_ - 252) / 2;
            int screenTop = (this.f_96544_ - 140) / 2;
            int screenCenterX = screenLeft + 126;
            int screenCenterY = screenTop + 70;
            double maxPanX = maxX * 38 + 26 - screenCenterX + screenLeft + 40;
            double minPanX = minX * 38 - screenCenterX + screenLeft + 252 - 40;
            double maxPanY = maxY * 30 + 26 - screenCenterY + screenTop + 40;
            double minPanY = minY * 30 - screenCenterY + screenTop + 140 - 40;
            this.panX = Mth.m_14008_((double)(this.panX - dragX), (double)(-maxPanX), (double)(-minPanX));
            this.panY = Mth.m_14008_((double)(this.panY - dragY), (double)(-maxPanY), (double)(-minPanY));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        int x = (this.f_96543_ - 252) / 2;
        int y = (this.f_96544_ - 140) / 2;
        this.renderWindow(guiGraphics, x, y);
        for (AbilityTabWidget tab : this.tabs.values()) {
            tab.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.m_280588_(x, y, x + 252, y + 140);
        this.renderConnections(guiGraphics, x, y);
        for (SkillWidget widget : this.skills.values()) {
            widget.updatePosition(x, y, (int)this.panX, (int)this.panY);
            if (!widget.f_93624_) continue;
            widget.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.m_280618_();
        this.renderTooltips(guiGraphics, mouseX, mouseY, x, y);
        if (PopupHandler.isPopupActive()) {
            PopupHandler.getCurrentPopup().render(guiGraphics, mouseX, mouseY, (Screen)this);
        }
    }

    private void renderWindow(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            guiGraphics.m_280163_(this.selectedTab.tabData.background(), x, y, (float)this.panX, (float)this.panY, 252, 140, 32, 32);
        }
        guiGraphics.m_280218_(WINDOW_LOCATION, x, y, 0, 0, 252, 140);
        if (this.selectedTab != null) {
            guiGraphics.m_280614_(this.f_96547_, this.selectedTab.tabData.name(), x + 8, y + 6, 0x404040, false);
        }
    }

    private void renderConnections(GuiGraphics gui, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS_LOCATION);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SkillWidget widget : this.skills.values()) {
            if (!widget.f_93624_) continue;
            for (ResourceLocation depId : widget.skill.dependencies()) {
                SkillWidget parentWidget = this.skills.get(depId);
                if (parentWidget == null || !parentWidget.f_93624_) continue;
                this.drawConnectionLine(gui, widget.m_252754_(), widget.m_252907_(), parentWidget.m_252754_(), parentWidget.m_252907_(), widget.skill.isUnlocked());
            }
        }
    }

    private void drawConnectionLine(GuiGraphics gui, int childX, int childY, int parentX, int parentY, boolean unlocked) {
        int x1 = childX + 13;
        int y1 = childY + 13;
        int x2 = parentX + 13;
        int y2 = parentY + 13;
        int vOffset = unlocked ? 0 : 16;
        RenderSystem.enableBlend();
        int dx = x1 - x2;
        int dy = y1 - y2;
        if (dx == 0) {
            gui.m_280218_(WIDGETS_LOCATION, x1 - 5, y2, 0, 166 + vOffset, 10, dy);
        } else if (dy == 0) {
            gui.m_280218_(WIDGETS_LOCATION, x2, y1 - 5, 0, 166 + vOffset, dx, 10);
        } else {
            int xDir = Mth.m_14205_((double)dx);
            int yDir = Mth.m_14205_((double)dy);
            int cornerX = x1;
            int cornerY = y2;
            gui.m_280218_(WIDGETS_LOCATION, x2, y2 - 5, 0, 166 + vOffset, dx, 10);
            gui.m_280218_(WIDGETS_LOCATION, x1 - 5, y2, 0, 166 + vOffset, 10, dy);
            gui.m_280218_(WIDGETS_LOCATION, x1 - 5, y2 - 5, xDir * yDir > 0 ? 0 : 10, 176 + vOffset, 10, 10);
        }
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        for (AbilityTabWidget tab : this.tabs.values()) {
            if (!tab.m_5953_(mouseX, mouseY)) continue;
            guiGraphics.m_280557_(this.f_96547_, tab.tabData.name(), mouseX, mouseY);
        }
        if (mouseX > x && mouseX < x + 252 && mouseY > y && mouseY < y + 140) {
            for (SkillWidget widget : this.skills.values()) {
                if (!widget.f_93624_ || !widget.m_5953_(mouseX, mouseY)) continue;
                widget.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(null);
        }
    }

    class SkillWidget
    extends AdvancedButton {
        private final S2C_OpenSkillTreeScreenPacket.SkillData skill;

        public SkillWidget(S2C_OpenSkillTreeScreenPacket.SkillData skill) {
            super(0, 0, 26, 26, skill.name().getString(), true, btn -> {});
            this.skill = skill;
            this.f_93624_ = false;
        }

        public void updatePosition(int screenX, int screenY, int panX, int panY) {
            int x = screenX + 126 - 13 + this.skill.x() * 38 + panX;
            int y = screenY + 70 - 13 + this.skill.y() * 30 + panY;
            this.m_252865_(x);
            this.m_253211_(y);
        }

        public void m_5691_() {
            if (this.skill.canUnlock() && SkillTreeScreen.this.f_96541_ != null) {
                MutableComponent title = Component.m_237113_((String)"Unlock ").m_7220_(this.skill.name()).m_130946_("?");
                MutableComponent cost = this.skill.costDescription().getString().isEmpty() ? Component.m_237113_((String)"This skill is free.") : Component.m_237113_((String)"This will cost: ").m_7220_(this.skill.costDescription());
                PopupHandler.displayPopup((Popup)new YesNoPopup(250, null, 150, confirmed -> {
                    if (confirmed.booleanValue()) {
                        PacketRegistry.sendToServer(new C2S_UnlockSkillPacket(this.skill.id()));
                    }
                    if (SkillTreeScreen.this.f_96541_ != null) {
                        SkillTreeScreen.this.f_96541_.m_91152_((Screen)SkillTreeScreen.this);
                    }
                }, new String[]{title.getString(), cost.getString()}));
            }
        }

        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
            if (!this.f_93624_) {
                return;
            }
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_93617_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int u = 0;
            int v = 128;
            u = this.skill.isUnlocked() ? 26 : (this.skill.canUnlock() ? 0 : 52);
            gui.m_280218_(f_93617_, this.m_252754_(), this.m_252907_(), u, v, this.f_93618_, this.f_93619_);
            gui.m_280163_(this.skill.icon(), this.m_252754_() + 5, this.m_252907_() + 5, 0.0f, 0.0f, 16, 16, 16, 16);
        }

        public void renderTooltip(GuiGraphics gui, int mouseX, int mouseY) {
            if (SkillTreeScreen.this.f_96547_ == null) {
                return;
            }
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(this.skill.name().m_6881_().m_130940_(this.skill.isUnlocked() ? ChatFormatting.GREEN : ChatFormatting.WHITE));
            List descLines = SkillTreeScreen.this.f_96547_.m_92923_((FormattedText)this.skill.description(), 150);
            for (Object line : descLines) {
                tooltip.add(Component.m_237113_((String)line.toString()));
            }
            tooltip.add(Component.m_237113_((String)""));
            if (this.skill.isUnlocked()) {
                tooltip.add(Component.m_237113_((String)"UNLOCKED").m_130940_(ChatFormatting.GREEN));
            } else {
                boolean depsMet = true;
                for (ResourceLocation depId : this.skill.dependencies()) {
                    SkillWidget parent = SkillTreeScreen.this.skills.get(depId);
                    if (parent == null || parent.skill.isUnlocked()) continue;
                    depsMet = false;
                    tooltip.add(Component.m_237113_((String)"Req: ").m_130940_(ChatFormatting.RED).m_7220_(parent.skill.name()));
                }
                Component cost = this.skill.costDescription().getString().isEmpty() ? Component.m_237113_((String)"Free").m_130940_(ChatFormatting.GREEN) : this.skill.costDescription();
                Style costStyle = this.skill.canUnlock() ? Style.f_131099_.m_131140_(ChatFormatting.GREEN) : Style.f_131099_.m_131140_(ChatFormatting.RED);
                tooltip.add(Component.m_237113_((String)"Cost: ").m_130940_(depsMet ? ChatFormatting.WHITE : ChatFormatting.DARK_GRAY).m_7220_((Component)cost.m_6881_().m_130948_(costStyle)));
                if (this.skill.canUnlock()) {
                    tooltip.add(Component.m_237113_((String)"Click to unlock").m_130940_(ChatFormatting.YELLOW));
                }
            }
            gui.m_280666_(SkillTreeScreen.this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    class AbilityTabWidget
    extends AdvancedButton {
        private final S2C_OpenSkillTreeScreenPacket.AbilityTabData tabData;
        private boolean isSelected;
        private final Consumer<AbilityTabWidget> onClick;

        public AbilityTabWidget(S2C_OpenSkillTreeScreenPacket.AbilityTabData tabData, Consumer<AbilityTabWidget> onClick) {
            super(0, 0, 28, 32, tabData.name().getString(), true, btn -> {});
            this.tabData = tabData;
            this.onClick = onClick;
        }

        public void m_5691_() {
            this.onClick.accept(this);
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_93617_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int vOffset = 0;
            if (this.isSelected) {
                vOffset = 32;
            } else if (this.f_93622_) {
                vOffset = 64;
            }
            gui.m_280218_(f_93617_, this.m_252754_(), this.m_252907_(), 0, vOffset, this.f_93618_, this.f_93619_);
            gui.m_280163_(this.tabData.icon(), this.m_252754_() + 6, this.m_252907_() + 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }
}

