/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.soulbind.SoulbindManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class C2S_SendRequestPacket {
    private final UUID targetUUID;
    private final String role;

    public C2S_SendRequestPacket(UUID targetUUID, String role) {
        this.targetUUID = targetUUID;
        this.role = role;
    }

    public static void encode(C2S_SendRequestPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.targetUUID);
        buf.m_130070_(msg.role);
    }

    public static C2S_SendRequestPacket decode(FriendlyByteBuf buf) {
        return new C2S_SendRequestPacket(buf.m_130259_(), buf.m_130277_());
    }

    public static void handle(C2S_SendRequestPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && sender.m_20194_() != null) {
                ServerPlayer target = sender.m_20194_().m_6846_().m_11259_(msg.targetUUID);
                if (target == null) {
                    sender.m_213846_((Component)Component.m_237113_((String)"\u00a7cThat player is no longer online."));
                } else if (sender.m_20148_().equals(msg.targetUUID)) {
                    sender.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou cannot send a request to yourself."));
                } else {
                    SoulbindManager.handleSoulbindRequest(sender, target, msg.role);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

