/*
 * Decompiled with CFR 0.152.
 */
package net.sapphic.kindredsouls.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.api.ISkill;
import com.sapphic.kindredsouls.soulbind.SoulbindManager;
import com.sapphic.kindredsouls.soulbind.SoulbindSaveData;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kindred_souls", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkillCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"skill_id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> {
            Collection<ISkill> allSkills = IKindredSoulsAPI.getInstance().getSkillRegistry().getAllSkills();
            return SharedSuggestionProvider.m_82981_(allSkills.stream().map(skill -> skill.getId().toString()), (SuggestionsBuilder)builder);
        }).executes(context -> SkillCommand.grantSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"skill_id"))))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"skill_id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> {
            Collection unlockedSkills;
            ServerPlayer player = null;
            try {
                player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            }
            catch (CommandSyntaxException e) {
                return SharedSuggestionProvider.m_82981_(IKindredSoulsAPI.getInstance().getSkillRegistry().getAllSkills().stream().map(skill -> skill.getId().toString()), (SuggestionsBuilder)builder);
            }
            SoulbindSaveData data = SoulbindManager.getSaveData();
            if (data != null && player != null && (unlockedSkills = (Collection)data.getUnlockedSkills().get(player.m_20148_())) != null) {
                return SharedSuggestionProvider.m_82970_((Iterable)unlockedSkills, (SuggestionsBuilder)builder);
            }
            return builder.buildFuture();
        }).executes(context -> SkillCommand.revokeSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"skill_id"))))));
        event.getDispatcher().register(command);
    }

    private static int grantSkill(CommandSourceStack source, ServerPlayer player, ResourceLocation skillId) {
        ISkill skill = IKindredSoulsAPI.getInstance().getSkillRegistry().getSkill(skillId);
        if (skill == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.kindredsouls.skill.not_found", (Object[])new Object[]{skillId.toString()}));
            return 0;
        }
        SoulbindManager.unlockSkill(player, skillId);
        source.m_288197_(() -> Component.m_237110_((String)"commands.kindredsouls.skill.grant.success", (Object[])new Object[]{skill.getDisplayName(), player.m_5446_()}), true);
        player.m_213846_((Component)Component.m_237113_((String)"An admin granted you the skill: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)skill.getDisplayName().m_6881_().m_130940_(ChatFormatting.GREEN)));
        SoulbindManager.openSkillTreeScreen(player);
        return 1;
    }

    private static int revokeSkill(CommandSourceStack source, ServerPlayer player, ResourceLocation skillId) {
        ISkill skill = IKindredSoulsAPI.getInstance().getSkillRegistry().getSkill(skillId);
        if (skill == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.kindredsouls.skill.not_found", (Object[])new Object[]{skillId.toString()}));
            return 0;
        }
        SoulbindManager.revokeSkill(player, skillId);
        source.m_288197_(() -> Component.m_237110_((String)"commands.kindredsouls.skill.revoke.success", (Object[])new Object[]{skill.getDisplayName(), player.m_5446_()}), true);
        player.m_213846_((Component)Component.m_237113_((String)"An admin revoked the skill: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)skill.getDisplayName().m_6881_().m_130940_(ChatFormatting.RED)));
        SoulbindManager.openSkillTreeScreen(player);
        return 1;
    }
}

