package com.example.examplemod.content.ability;

import com.example.examplemod.ExampleMod;
import com.sapphic.kindredsouls.api.AbilityRole;
import com.sapphic.kindredsouls.api.IAbilityType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ExampleWardAbilityType implements IAbilityType {

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation(ExampleMod.MODID, "example_ward");
    }

    @Override
    public AbilityRole getRole() {
        return AbilityRole.WARD;
    }

    @Override
    public Component getDisplayName() {
        return Component.literal("Example Ward");
    }

    @Override
    public Component getDescription() {
        return Component.literal("An example ability type for the Ward role.");
    }

    @Override
    public Component getLore() {
        return Component.empty(); 
    }

    @Override
    public ResourceLocation getIconTexture() {
        // src/main/resources/assets/examplemod/textures/ability/ward_icon.png
        return new ResourceLocation(ExampleMod.MODID, "textures/ability/ward_icon.png");
    }

    @Override
    public ResourceLocation getTabBackgroundTexture() {
        return new ResourceLocation("minecraft", "textures/gui/advancements/backgrounds/stone.png");
    }
}