package com.example.examplemod.content.skill;

import com.example.examplemod.core.AddonSkills;
import com.sapphic.kindredsouls.api.AbilityRegistry;
import com.sapphic.kindredsouls.api.ISkill;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

import java.util.Collections;
import java.util.List;

/**
 * This is a minimal implementation of an ISkill from the API.
 */
public class ExampleSkill implements ISkill {

    @Override
    public ResourceLocation getId() {
        // Unique ID for this skill
        return AddonSkills.rl("example_skill");
    }

    @Override
    public ResourceLocation getParentAbilityType() {
        // This attaches the skill to the "Default Guardian" ability tab
        // You could also use AbilityRegistry.DEFAULT_WARD or a custom one.
        return AbilityRegistry.DEFAULT_GUARDIAN.getId();
    }

    @Override
    public Component getDisplayName() {
        return Component.literal("Example Addon Skill");
    }

    @Override
    public Component getDescription() {
        return Component.literal("This is an example skill added by an addon.");
    }

    @Override
    public ResourceLocation getIconTexture() {
        // This texture needs to be created in:
        // src/main/resources/assets/examplemod/textures/skill/example_icon.png
        return AddonSkills.rl("textures/skill/example_icon.png");
    }

    @Override
    public int getX() {
        return 1; // 1 column to the right of the center (0,0)
    }

    @Override
    public int getY() {
        return 0; // Same row as the center (0,0)
    }

    @Override
    public List<ResourceLocation> getDependencies() {
        // This skill has no dependencies, so it can be unlocked immediately.
        return Collections.emptyList();
    }
}