package com.example.examplemod.core;

import com.example.examplemod.ExampleMod;
import com.example.examplemod.content.ability.ExampleWardAbilityType;
import com.sapphic.kindredsouls.api.AbilityRegistry;
import com.sapphic.kindredsouls.api.IAbilityType;
import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import net.minecraft.resources.ResourceLocation;

public class AddonAbilityTypes {

    
    public static final IAbilityType EXAMPLE_WARD_TYPE = new ExampleWardAbilityType();

    /**
     * This method will be called by AddonSkills to register the ability types.
     * It's important to register Ability Types *before* the Skills that depend on them.
     */

    
    public static void register() {
        AbilityRegistry registry = IKindredSoulsAPI.getInstance().getAbilityRegistry();
        
        registry.register(EXAMPLE_WARD_TYPE);
    }
    
    // Helper method
    public static ResourceLocation rl(String path) {
        return new ResourceLocation(ExampleMod.MODID, path);
    }
}