/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.api;

import com.sapphic.kindredsouls.api.ISkill;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.sapphic.kindredsouls.KindredSoulsMod;

public class SkillRegistry {
    private final Map<ResourceLocation, ISkill> registry = new ConcurrentHashMap<ResourceLocation, ISkill>();

    public void register(ISkill skill) {
        if (this.registry.containsKey(skill.getId())) {
            KindredSoulsMod.LOGGER.warn("Duplicate skill registration: {}", (Object)skill.getId());
        } else {
            this.registry.put(skill.getId(), skill);
            KindredSoulsMod.LOGGER.info("Registered skill: {} for Ability Type: {}", (Object)skill.getId(), (Object)skill.getParentAbilityType());
        }
    }

    public ISkill getSkill(ResourceLocation id) {
        return this.registry.get(id);
    }

    public Collection<ISkill> getSkillsForAbilityType(ResourceLocation abilityTypeId) {
        return this.registry.values().stream().filter(skill -> skill.getParentAbilityType().equals((Object)abilityTypeId)).collect(Collectors.toList());
    }

    public Collection<ISkill> getAllSkills() {
        return this.registry.values();
    }
}

