/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.api.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbilityLoreRegistry {
    private static final Map<ResourceLocation, LoreEntry> REGISTRY = new HashMap<ResourceLocation, LoreEntry>();
    private static final Component DEFAULT_DESC = Component.m_237115_((String)"gui.kindred_souls.abilityselect.default_desc").m_130940_(ChatFormatting.GRAY);

    public static void register(ResourceLocation id, Component description, Component lore) {
        REGISTRY.put(id, new LoreEntry(description, lore));
    }

    public static void register(ResourceLocation id, Component description, String lore) {
        AbilityLoreRegistry.register(id, description, (Component)Component.m_237113_((String)lore));
    }

    public static void register(ResourceLocation id, String description, String lore) {
        AbilityLoreRegistry.register(id, (Component)Component.m_237113_((String)description), (Component)Component.m_237113_((String)lore));
    }

    public static void register(ResourceLocation id, String description) {
        AbilityLoreRegistry.register(id, (Component)Component.m_237113_((String)description), (Component)Component.m_237119_());
    }

    public static boolean has(ResourceLocation id) {
        return REGISTRY.containsKey(id);
    }

    public static LoreEntry get(ResourceLocation id) {
        return REGISTRY.getOrDefault(id, new LoreEntry(DEFAULT_DESC, (Component)Component.m_237119_()));
    }

    public static void clear() {
        REGISTRY.clear();
    }

    public record LoreEntry(Component description, Component lore) {
    }
}

