/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sapphic.kindredsouls.api.client.AbilityLoreRegistry;
import com.sapphic.kindredsouls.client.gui.KonkreteScreenHandler;
import com.sapphic.kindredsouls.network.C2S_SetAbilityTypePacket;
import com.sapphic.kindredsouls.network.PacketRegistry;
import com.sapphic.kindredsouls.network.S2C_OpenAbilityTypeScreenPacket;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbilityTypeSelectionScreen
extends Screen {
    private final List<S2C_OpenAbilityTypeScreenPacket.AbilityTypeData> availableTypes;
    private int currentPage = 0;
    private AdvancedButton prevButton;
    private AdvancedButton nextButton;
    private AdvancedButton selectButton;
    private ScrollArea contentScrollArea;
    private KonkreteScreenHandler contentScrollHandler;
    private static final Component TITLE = Component.m_237115_((String)"gui.kindred_souls.abilityselect.title");
    private static final Component LORE_TITLE = Component.m_237115_((String)"gui.kindred_souls.abilityselect.lore").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
    private static final Component PREV_BUTTON = Component.m_237113_((String)"<");
    private static final Component NEXT_BUTTON = Component.m_237113_((String)">");
    private static final Component SELECT_BUTTON = Component.m_237115_((String)"gui.kindred_souls.abilityselect.select");
    private static final Component NO_ABILITIES = Component.m_237115_((String)"gui.kindred_souls.abilityselect.none").m_130940_(ChatFormatting.RED);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected static final Color BUTTON_COLOR_IDLE = new Color(100, 100, 100);
    protected static final Color BUTTON_COLOR_HOVER = new Color(130, 130, 130);
    protected static final Color BUTTON_COLOR_BORDER = new Color(180, 180, 180);

    public AbilityTypeSelectionScreen(List<S2C_OpenAbilityTypeScreenPacket.AbilityTypeData> availableTypes) {
        super(TITLE);
        this.availableTypes = availableTypes;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null) {
            int buttonWidth = 100;
            int smallButtonWidth = 40;
            int buttonY = this.f_96544_ - 35;
            int buttonGap = 10;
            int selectButtonX = this.f_96543_ / 2 - buttonWidth / 2;
            this.selectButton = new AdvancedButton(selectButtonX, buttonY, buttonWidth, 20, SELECT_BUTTON.getString(), true, btn -> {
                if (!this.availableTypes.isEmpty()) {
                    S2C_OpenAbilityTypeScreenPacket.AbilityTypeData selected = this.availableTypes.get(this.currentPage);
                    PacketRegistry.sendToServer(new C2S_SetAbilityTypePacket(selected.getId()));
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_((Screen)null);
                    }
                }
            });
            this.colorizeButton(this.selectButton);
            this.m_142416_((GuiEventListener)this.selectButton);
            int prevButtonX = selectButtonX - smallButtonWidth - buttonGap;
            this.prevButton = new AdvancedButton(prevButtonX, buttonY, smallButtonWidth, 20, PREV_BUTTON.getString(), true, btn -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                    this.populateContentScrollArea();
                }
            });
            this.colorizeButton(this.prevButton);
            this.m_142416_((GuiEventListener)this.prevButton);
            int nextButtonX = selectButtonX + buttonWidth + buttonGap;
            this.nextButton = new AdvancedButton(nextButtonX, buttonY, smallButtonWidth, 20, NEXT_BUTTON.getString(), true, btn -> {
                if (this.currentPage < this.availableTypes.size() - 1) {
                    ++this.currentPage;
                    this.populateContentScrollArea();
                }
            });
            this.colorizeButton(this.nextButton);
            this.m_142416_((GuiEventListener)this.nextButton);
            int scrollY = 155;
            int scrollHeight = this.f_96544_ - 40 - scrollY - 5;
            int scrollWidth = this.f_96543_ - 100;
            int scrollX = (this.f_96543_ - scrollWidth) / 2;
            this.contentScrollArea = new ScrollArea(scrollX, scrollY, scrollWidth, scrollHeight);
            this.contentScrollArea.backgroundColor = SCREEN_BACKGROUND_COLOR;
            this.contentScrollHandler = new KonkreteScreenHandler(this.contentScrollArea);
            this.m_142416_((GuiEventListener)this.contentScrollHandler);
            this.populateContentScrollArea();
        }
    }

    private void populateContentScrollArea() {
        if (this.contentScrollArea != null) {
            this.contentScrollArea.getEntries().clear();
            this.updateButtons();
            if (!this.availableTypes.isEmpty()) {
                S2C_OpenAbilityTypeScreenPacket.AbilityTypeData currentType = this.availableTypes.get(this.currentPage);
                int wrapWidth = this.contentScrollArea.width - 10;
                ResourceLocation id = currentType.getId();
                AbilityLoreRegistry.LoreEntry loreEntry = AbilityLoreRegistry.get(id);
                Component descriptionComponent = loreEntry.description();
                Component loreComponent = loreEntry.lore();
                this.contentScrollArea.addEntry((ScrollAreaEntry)new TextEntry(this.contentScrollArea, descriptionComponent, wrapWidth, Style.f_131099_.m_131140_(ChatFormatting.GRAY), 0));
                this.contentScrollArea.addEntry((ScrollAreaEntry)new SpacerEntry(this.contentScrollArea, 10));
                this.contentScrollArea.addEntry((ScrollAreaEntry)new TextEntry(this.contentScrollArea, LORE_TITLE, wrapWidth, Style.f_131099_, 12));
                this.contentScrollArea.addEntry((ScrollAreaEntry)new TextEntry(this.contentScrollArea, loreComponent, wrapWidth, Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true)), 0));
                this.contentScrollArea.addEntry((ScrollAreaEntry)new SpacerEntry(this.contentScrollArea, 5));
            }
        }
    }

    private void updateButtons() {
        this.prevButton.setUseable(this.currentPage > 0);
        this.nextButton.setUseable(this.currentPage < this.availableTypes.size() - 1);
        this.selectButton.setUseable(!this.availableTypes.isEmpty());
    }

    private void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(BUTTON_COLOR_IDLE, BUTTON_COLOR_HOVER, BUTTON_COLOR_BORDER, BUTTON_COLOR_BORDER, 1);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, SCREEN_BACKGROUND_COLOR.getRGB());
        guiGraphics.m_280509_(0, 0, this.f_96543_, 40, HEADER_FOOTER_COLOR.getRGB());
        guiGraphics.m_280653_(this.f_96547_, TITLE, this.f_96543_ / 2, 15, Color.WHITE.getRGB());
        guiGraphics.m_280509_(0, this.f_96544_ - 40, this.f_96543_, this.f_96544_, HEADER_FOOTER_COLOR.getRGB());
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.availableTypes.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, NO_ABILITIES, this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
        } else {
            S2C_OpenAbilityTypeScreenPacket.AbilityTypeData currentType = this.availableTypes.get(this.currentPage);
            MutableComponent page = Component.m_264642_((String)"gui.kindred_souls.abilityselect.page", (String)"%s/%s", (Object[])new Object[]{this.currentPage + 1, this.availableTypes.size()});
            guiGraphics.m_280653_(this.f_96547_, (Component)page, this.f_96543_ / 2, 48, 0xAAAAAA);
            ResourceLocation icon = currentType.getIcon();
            if (icon != null) {
                RenderSystem.enableBlend();
                guiGraphics.m_280163_(icon, this.f_96543_ / 2 - 32, 65, 0.0f, 0.0f, 64, 64, 64, 64);
                RenderSystem.disableBlend();
            }
            MutableComponent name = currentType.getName() != null ? currentType.getName() : Component.m_237119_();
            guiGraphics.m_280653_(this.f_96547_, (Component)name, this.f_96543_ / 2, 140, 0xFFFFFF);
            if (this.contentScrollArea != null) {
                this.contentScrollArea.render(guiGraphics);
            }
            if (PopupHandler.isPopupActive()) {
                PopupHandler.getCurrentPopup().render(guiGraphics, mouseX, mouseY, (Screen)this);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private class TextEntry
    extends ScrollAreaEntry {
        private final List<FormattedCharSequence> lines;
        private final int height;
        private final int textHeight;

        public TextEntry(ScrollArea parent, Component text, int wrapWidth, Style style, int padding) {
            super(parent);
            MutableComponent nonNullText = text == null ? Component.m_237119_() : text;
            this.lines = AbilityTypeSelectionScreen.this.f_96547_.m_92923_((FormattedText)nonNullText.m_6881_().m_6270_(style), wrapWidth);
            int textLines = this.lines.size();
            Objects.requireNonNull(AbilityTypeSelectionScreen.this.f_96547_);
            this.textHeight = textLines * (9 + 1);
            this.height = this.textHeight + padding;
        }

        public void renderEntry(GuiGraphics guiGraphics) {
            if (this.isVisible()) {
                int lineY = this.y + (this.height - this.textHeight) / 2;
                for (FormattedCharSequence line : this.lines) {
                    int centeredX = this.x + (this.getWidth() - this.parent.grabberwidth) / 2;
                    guiGraphics.m_280648_(AbilityTypeSelectionScreen.this.f_96547_, line, centeredX, lineY, 0xFFFFFF);
                    Objects.requireNonNull(AbilityTypeSelectionScreen.this.f_96547_);
                    lineY += 9 + 1;
                }
            }
        }

        public int getHeight() {
            return this.height;
        }
    }

    private static class SpacerEntry
    extends ScrollAreaEntry {
        private final int height;

        public SpacerEntry(ScrollArea parent, int height) {
            super(parent);
            this.height = height;
        }

        public void renderEntry(GuiGraphics guiGraphics) {
        }

        public int getHeight() {
            return this.height;
        }
    }
}

