/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.api.IKindredSoulsAPI;
import com.sapphic.kindredsouls.api.ISkill;
import com.sapphic.kindredsouls.api.ISkillUnlockCondition;
import com.sapphic.kindredsouls.soulbind.SoulbindManager;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class C2S_UnlockSkillPacket {
    private final ResourceLocation skillId;

    public C2S_UnlockSkillPacket(ResourceLocation skillId) {
        this.skillId = skillId;
    }

    public static void encode(C2S_UnlockSkillPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.skillId);
    }

    public static C2S_UnlockSkillPacket decode(FriendlyByteBuf buf) {
        return new C2S_UnlockSkillPacket(buf.m_130281_());
    }

    public static void handle(C2S_UnlockSkillPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            IKindredSoulsAPI api = IKindredSoulsAPI.getInstance();
            ISkill skill = api.getSkillRegistry().getSkill(msg.skillId);
            if (skill == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Unknown skill.").m_130940_(ChatFormatting.RED));
                return;
            }
            if (SoulbindManager.isSkillUnlocked(player, msg.skillId)) {
                player.m_213846_((Component)Component.m_237113_((String)"Skill already unlocked.").m_130940_(ChatFormatting.YELLOW));
                return;
            }
            for (ResourceLocation depId : skill.getDependencies()) {
                if (SoulbindManager.isSkillUnlocked(player, depId)) continue;
                ISkill depSkill = api.getSkillRegistry().getSkill(depId);
                Component depName = depSkill != null ? depSkill.getDisplayName() : Component.m_237113_((String)depId.toString());
                player.m_213846_((Component)Component.m_237113_((String)"You must first unlock: ").m_130940_(ChatFormatting.RED).m_7220_(depName));
                return;
            }
            ISkillUnlockCondition condition = api.getSkillUnlockRegistry().get(msg.skillId);
            if (condition.canUnlock(player, skill)) {
                condition.applyCost(player, skill);
                SoulbindManager.unlockSkill(player, msg.skillId);
                player.m_213846_((Component)Component.m_237113_((String)"Unlocked skill: ").m_130940_(ChatFormatting.GREEN).m_7220_(skill.getDisplayName()));
                SoulbindManager.openSkillTreeScreen(player);
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"You do not meet the requirements to unlock: ").m_130940_(ChatFormatting.RED).m_7220_(skill.getDisplayName()));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

