/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.client.ClientPacketHandler;
import com.sapphic.kindredsouls.network.RequestData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2C_OpenRequestScreenPacket {
    private final List<RequestData> requests;
    private final Map<UUID, UUID> boundPlayers;

    public S2C_OpenRequestScreenPacket(List<RequestData> requests, Map<UUID, UUID> boundPlayers) {
        this.requests = requests;
        this.boundPlayers = boundPlayers;
    }

    public List<RequestData> getRequests() {
        return this.requests;
    }

    public Map<UUID, UUID> getBoundPlayers() {
        return this.boundPlayers;
    }

    public static void encode(S2C_OpenRequestScreenPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.requests.size());
        for (RequestData r : msg.requests) {
            r.toBuffer(buf);
        }
        buf.writeInt(msg.boundPlayers.size());
        msg.boundPlayers.forEach((key, value) -> {
            buf.m_130077_(key);
            buf.m_130077_(value);
        });
    }

    public static S2C_OpenRequestScreenPacket decode(FriendlyByteBuf buf) {
        int reqSize = buf.readInt();
        ArrayList<RequestData> requests = new ArrayList<RequestData>();
        for (int i = 0; i < reqSize; ++i) {
            requests.add(RequestData.fromBuffer(buf));
        }
        int boundSize = buf.readInt();
        HashMap<UUID, UUID> bound = new HashMap<UUID, UUID>();
        for (int i = 0; i < boundSize; ++i) {
            bound.put(buf.m_130259_(), buf.m_130259_());
        }
        return new S2C_OpenRequestScreenPacket(requests, bound);
    }

    public static void handle(S2C_OpenRequestScreenPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleOpenRequestScreen(msg)));
        ctx.get().setPacketHandled(true);
    }
}

