/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.network;

import com.sapphic.kindredsouls.client.ClientPacketHandler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2C_OpenSkillTreeScreenPacket {
    private final List<AbilityTabData> tabData;
    private final List<SkillData> skillData;
    private final ResourceLocation selectedTabId;

    public S2C_OpenSkillTreeScreenPacket(List<AbilityTabData> tabData, List<SkillData> skillData, ResourceLocation selectedTabId) {
        this.tabData = tabData;
        this.skillData = skillData;
        this.selectedTabId = selectedTabId;
    }

    public List<AbilityTabData> getTabData() {
        return this.tabData;
    }

    public List<SkillData> getSkillData() {
        return this.skillData;
    }

    public ResourceLocation getSelectedTabId() {
        return this.selectedTabId;
    }

    public static void encode(S2C_OpenSkillTreeScreenPacket msg, FriendlyByteBuf buf) {
        buf.m_236828_(msg.tabData, (b, data) -> data.encode((FriendlyByteBuf)b));
        buf.m_236828_(msg.skillData, (b, data) -> data.encode((FriendlyByteBuf)b));
        buf.m_130085_(msg.selectedTabId);
    }

    public static S2C_OpenSkillTreeScreenPacket decode(FriendlyByteBuf buf) {
        return new S2C_OpenSkillTreeScreenPacket(buf.m_236845_(AbilityTabData::decode), buf.m_236845_(SkillData::decode), buf.m_130281_());
    }

    public static void handle(S2C_OpenSkillTreeScreenPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleOpenSkillTreeScreen(msg)));
        ctx.get().setPacketHandled(true);
    }

    public record SkillData(ResourceLocation id, ResourceLocation parentTabId, Component name, Component description, ResourceLocation icon, Component costDescription, boolean isUnlocked, boolean canUnlock, int x, int y, List<ResourceLocation> dependencies) {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130085_(this.id);
            buf.m_130085_(this.parentTabId);
            buf.m_130083_(this.name);
            buf.m_130083_(this.description);
            buf.m_130085_(this.icon);
            buf.m_130083_(this.costDescription);
            buf.writeBoolean(this.isUnlocked);
            buf.writeBoolean(this.canUnlock);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.m_236828_(this.dependencies, FriendlyByteBuf::m_130085_);
        }

        public static SkillData decode(FriendlyByteBuf buf) {
            return new SkillData(buf.m_130281_(), buf.m_130281_(), buf.m_130238_(), buf.m_130238_(), buf.m_130281_(), buf.m_130238_(), buf.readBoolean(), buf.readBoolean(), buf.readInt(), buf.readInt(), buf.m_236845_(FriendlyByteBuf::m_130281_));
        }
    }

    public record AbilityTabData(ResourceLocation id, Component name, ResourceLocation icon, ResourceLocation background) {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130085_(this.id);
            buf.m_130083_(this.name);
            buf.m_130085_(this.icon);
            buf.m_130085_(this.background);
        }

        public static AbilityTabData decode(FriendlyByteBuf buf) {
            return new AbilityTabData(buf.m_130281_(), buf.m_130238_(), buf.m_130281_(), buf.m_130281_());
        }
    }
}

