/*
 * Decompiled with CFR 0.152.
 */
package com.sapphic.kindredsouls.soulbind;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class SoulbindSaveData
extends SavedData {
    public static final String DATA_NAME = "kindred_souls_soulbind_data";
    private final Map<UUID, UUID> boundPairs = new HashMap<UUID, UUID>();
    private final Map<UUID, Boolean> isTwoWay = new HashMap<UUID, Boolean>();
    private final Map<UUID, String> playerRoles = new HashMap<UUID, String>();
    private final Map<UUID, String> playerAbilityTypes = new HashMap<UUID, String>();
    private final Map<UUID, Set<String>> unlockedSkills = new HashMap<UUID, Set<String>>();

    public SoulbindSaveData() {
    }

    public SoulbindSaveData(CompoundTag tag) {
        SoulbindSaveData.load(tag);
    }

    public Map<UUID, UUID> getBoundPairs() {
        return this.boundPairs;
    }

    public Map<UUID, Boolean> getIsTwoWay() {
        return this.isTwoWay;
    }

    public Map<UUID, String> getPlayerRoles() {
        return this.playerRoles;
    }

    public Map<UUID, String> getPlayerAbilityTypes() {
        return this.playerAbilityTypes;
    }

    public Map<UUID, Set<String>> getUnlockedSkills() {
        return this.unlockedSkills;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag pairsList = new ListTag();
        for (Map.Entry<UUID, UUID> entry : this.boundPairs.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("SourceUUID", entry.getKey().toString());
            compoundTag.m_128359_("TargetUUID", entry.getValue().toString());
            compoundTag.m_128379_("IsTwoWay", this.isTwoWay.getOrDefault(entry.getKey(), false).booleanValue());
            pairsList.add((Object)compoundTag);
        }
        tag.m_128365_("SoulbindPairs", (Tag)pairsList);
        ListTag rolesList = new ListTag();
        for (Map.Entry<UUID, String> entry : this.playerRoles.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("UUID", entry.getKey().toString());
            entryTag.m_128359_("Role", entry.getValue());
            String type = this.playerAbilityTypes.get(entry.getKey());
            if (type != null) {
                entryTag.m_128359_("AbilityType", type);
            }
            rolesList.add((Object)entryTag);
        }
        tag.m_128365_("PlayerRoles", (Tag)rolesList);
        ListTag listTag = new ListTag();
        this.unlockedSkills.forEach((playerUUID, skills) -> {
            CompoundTag playerSkillsTag = new CompoundTag();
            playerSkillsTag.m_128362_("UUID", playerUUID);
            ListTag skillIds = new ListTag();
            for (String skillId : skills) {
                skillIds.add((Object)StringTag.m_129297_((String)skillId));
            }
            playerSkillsTag.m_128365_("Skills", (Tag)skillIds);
            skillsList.add((Object)playerSkillsTag);
        });
        tag.m_128365_("UnlockedSkills", (Tag)listTag);
        return tag;
    }

    public static SoulbindSaveData load(CompoundTag tag) {
        SoulbindSaveData data = new SoulbindSaveData();
        ListTag pairsList = tag.m_128437_("SoulbindPairs", 10);
        for (int i = 0; i < pairsList.size(); ++i) {
            CompoundTag entryTag = pairsList.m_128728_(i);
            try {
                UUID source = UUID.fromString(entryTag.m_128461_("SourceUUID"));
                UUID target = UUID.fromString(entryTag.m_128461_("TargetUUID"));
                boolean twoWay = entryTag.m_128471_("IsTwoWay");
                data.boundPairs.put(source, target);
                data.isTwoWay.put(source, twoWay);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to load soulbind UUID: " + e.getMessage());
            }
        }
        ListTag rolesList = tag.m_128437_("PlayerRoles", 10);
        for (int i = 0; i < rolesList.size(); ++i) {
            CompoundTag entryTag = rolesList.m_128728_(i);
            try {
                UUID uuid = UUID.fromString(entryTag.m_128461_("UUID"));
                String role = entryTag.m_128461_("Role");
                data.playerRoles.put(uuid, role);
                if (!entryTag.m_128425_("AbilityType", 8)) continue;
                data.playerAbilityTypes.put(uuid, entryTag.m_128461_("AbilityType"));
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to load player role UUID: " + e.getMessage());
            }
        }
        ListTag skillsList = tag.m_128437_("UnlockedSkills", 10);
        for (int i = 0; i < skillsList.size(); ++i) {
            try {
                CompoundTag playerSkillsTag = skillsList.m_128728_(i);
                UUID playerUUID = playerSkillsTag.m_128342_("UUID");
                ListTag skillIds = playerSkillsTag.m_128437_("Skills", 8);
                HashSet<String> skills = new HashSet<String>();
                for (Tag skillTag : skillIds) {
                    skills.add(skillTag.m_7916_());
                }
                data.unlockedSkills.put(playerUUID, skills);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to load player skill data: " + e.getMessage());
            }
        }
        return data;
    }

    public static SoulbindSaveData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            DimensionDataStorage storage = serverLevel.m_8895_();
            return (SoulbindSaveData)storage.m_164861_(SoulbindSaveData::load, SoulbindSaveData::new, DATA_NAME);
        }
        return new SoulbindSaveData();
    }
}

