/*
 * Decompiled with CFR 0.152.
 */
package jurassicrevived.client.renderer;

import jurassicrevived.client.model.ModelDilophosaurus;
import jurassicrevived.client.model.animations.DilophosaurusAnimation;
import jurassicrevived.entity.DilophosaurusEntity;
import jurassicrevived.procedures.TrexRunProcedure;
import jurassicrevived.procedures.TrexWalkProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DilophosaurusRenderer
extends MobRenderer<DilophosaurusEntity, ModelDilophosaurus<DilophosaurusEntity>> {
    public DilophosaurusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.m_174023_(ModelDilophosaurus.LAYER_LOCATION)), 0.7f);
    }

    public ResourceLocation getTextureLocation(DilophosaurusEntity entity) {
        return new ResourceLocation("jurassic_revived:textures/entities/dilophosaurus_male.png");
    }

    private static final class AnimatedModel
    extends ModelDilophosaurus<DilophosaurusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DilophosaurusEntity>(){

            public ModelPart m_142109_() {
                return root;
            }

            public void setupAnim(DilophosaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.m_233385_(entity.animationState0, DilophosaurusAnimation.Idle, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState1, DilophosaurusAnimation.IdleTwo, ageInTicks, 1.0f);
                if (TrexWalkProcedure.execute((Entity)entity)) {
                    this.m_267799_(DilophosaurusAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 3.0f);
                }
                if (TrexRunProcedure.execute((Entity)entity)) {
                    this.m_267799_(DilophosaurusAnimation.Run, limbSwing, limbSwingAmount, 1.0f, 3.0f);
                }
                this.m_233385_(entity.animationState4, DilophosaurusAnimation.Attack, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState5, DilophosaurusAnimation.Mouth, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupAnim(DilophosaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

