/*
 * Decompiled with CFR 0.152.
 */
package jurassicrevived.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import jurassicrevived.client.model.ModelSpinosaurus;
import jurassicrevived.client.model.animations.SpinosaurusAnimation;
import jurassicrevived.entity.SpinosaurusEntity;
import jurassicrevived.procedures.SpinoRunProcedure;
import jurassicrevived.procedures.SpinoWalkProcedure;
import jurassicrevived.procedures.SpinoWaterProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SpinosaurusRenderer
extends MobRenderer<SpinosaurusEntity, ModelSpinosaurus<SpinosaurusEntity>> {
    public SpinosaurusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.m_174023_(ModelSpinosaurus.LAYER_LOCATION)), 2.0f);
    }

    protected void scale(SpinosaurusEntity entity, PoseStack poseStack, float f) {
        poseStack.m_85841_(2.5f, 2.5f, 2.5f);
    }

    public ResourceLocation getTextureLocation(SpinosaurusEntity entity) {
        return new ResourceLocation("jurassic_revived:textures/entities/spinosaurus_male.png");
    }

    private static final class AnimatedModel
    extends ModelSpinosaurus<SpinosaurusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SpinosaurusEntity>(){

            public ModelPart m_142109_() {
                return root;
            }

            public void setupAnim(SpinosaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.m_233385_(entity.animationState0, SpinosaurusAnimation.Attack, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState1, SpinosaurusAnimation.Mouth, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState2, SpinosaurusAnimation.Idle, ageInTicks, 1.0f);
                if (SpinoWalkProcedure.execute((Entity)entity)) {
                    this.m_267799_(SpinosaurusAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
                if (SpinoRunProcedure.execute((Entity)entity)) {
                    this.m_267799_(SpinosaurusAnimation.Run, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
                this.m_233385_(entity.animationState5, SpinosaurusAnimation.Swim, ageInTicks, 1.0f);
                if (SpinoWaterProcedure.execute((Entity)entity)) {
                    this.m_267799_(SpinosaurusAnimation.Swimming, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                }
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupAnim(SpinosaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

