/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common;

import com.eerussianguy.ez_supervisor.EZSupervisor;
import com.eerussianguy.ez_supervisor.common.data.SpawnPredicate;
import com.eerussianguy.ez_supervisor.common.data.SpawnRestriction;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class ForgeEvents {
    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(EventPriority.LOW, ForgeEvents::onCheckSpawn);
        bus.addListener(EventPriority.LOW, ForgeEvents::onEntityLoot);
    }

    public static void onCheckSpawn(MobSpawnEvent.PositionCheck event) {
        ServerLevelAccessor server = event.getLevel();
        Mob entity = event.getEntity();
        SpawnRestriction restriction = Objects.requireNonNull(EZSupervisor.restrictions).get(entity.getType());
        if (restriction != null) {
            List<SpawnPredicate> predicates = restriction.predicates();
            for (SpawnPredicate predicate : predicates) {
                if (predicate.test((Entity)entity, server, event.getSpawnType(), entity.blockPosition(), entity.getRandom())) continue;
                event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
                break;
            }
        }
    }

    public static void onEntityLoot(LivingDropsEvent event) {
        HashSet usedNoIngredientFilters = new HashSet();
        LivingEntity deadEntity = event.getEntity();
        for (ItemEntity entity : event.getDrops()) {
            ItemStack stack = entity.getItem();
            int count = stack.getCount();
            Objects.requireNonNull(EZSupervisor.entityLootFilters).forEach(filter -> {
                if (filter.ingredient() == null) {
                    if (filter.output() != Items.AIR && !usedNoIngredientFilters.contains(filter)) {
                        usedNoIngredientFilters.add(filter);
                        deadEntity.spawnAtLocation(new ItemStack((ItemLike)filter.output(), Mth.ceil((float)filter.outputMultiplier())));
                    }
                } else if ((filter.entities().isEmpty() || filter.entities().contains(entity.getType())) && filter.ingredient().test(stack) && (!filter.killedByPlayer() || event.getSource().getEntity() instanceof Player)) {
                    entity.setItem(ItemStack.EMPTY);
                    entity.discard();
                    if (filter.output() != Items.AIR) {
                        deadEntity.spawnAtLocation(new ItemStack((ItemLike)filter.output(), Mth.ceil((float)(filter.outputMultiplier() * (float)count))));
                    }
                }
            });
        }
    }
}

