/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common;

import com.eerussianguy.ez_supervisor.EZSupervisor;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import org.slf4j.Logger;

public record SpawnModifierProvider() implements BiomeModifier
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SpawnModifierProvider INSTANCE = new SpawnModifierProvider();

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
        if (phase == BiomeModifier.Phase.ADD) {
            assert (EZSupervisor.spawns != null);
            EZSupervisor.spawns.forEach(spawn -> {
                if (spawn.biomes().isEmpty() || spawn.biomes().contains(((ResourceKey)biome.unwrapKey().get()).location())) {
                    LOGGER.debug("Adding spawn {} to biome {}", spawn.types(), (Object)((ResourceKey)biome.unwrapKey().get()).location());
                    spawn.types().forEach(entity -> spawns.addSpawn(entity.getCategory(), new MobSpawnSettings.SpawnerData(entity, spawn.weight(), spawn.minCount(), spawn.maxCount())));
                }
            });
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)EZSupervisor.ADD_EZ_SPAWNS_BIOME_MODIFIER_TYPE.get();
    }
}

