/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common.data;

import com.eerussianguy.ez_supervisor.common.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;

public record BiomeSpawn(List<EntityType<?>> types, List<ResourceLocation> biomes, int minCount, int maxCount, int weight) {
    public static List<BiomeSpawn> readAll(JsonArray json) {
        return ParsingUtils.mapArray(json, e -> BiomeSpawn.create(e.getAsJsonObject()));
    }

    public static BiomeSpawn create(JsonObject json) {
        List<EntityType<?>> mobs = ParsingUtils.getAsEntityList(json);
        List<ResourceLocation> biomes = !json.has("biomes") ? List.of() : ParsingUtils.mapArray(json.getAsJsonArray("biomes"), e -> ResourceLocation.parse((String)e.getAsString()));
        int minCount = GsonHelper.getAsInt((JsonObject)json, (String)"min_count", (int)1);
        int maxCount = GsonHelper.getAsInt((JsonObject)json, (String)"max_count", (int)4);
        int weight = GsonHelper.getAsInt((JsonObject)json, (String)"weight", (int)1);
        return new BiomeSpawn(mobs, biomes, minCount, maxCount, weight);
    }
}

