/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common.data;

import com.eerussianguy.ez_supervisor.common.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record LootFilter(List<EntityType<?>> entities, @Nullable Ingredient ingredient, Item output, float outputMultiplier, boolean killedByPlayer) {
    public static List<LootFilter> readAll(JsonArray array) {
        return ParsingUtils.mapArray(array, e -> LootFilter.create(e.getAsJsonObject()));
    }

    public static LootFilter create(JsonObject json) {
        JsonElement ingredientJson;
        List<EntityType<?>> type;
        List<Object> list = type = json.has("entity") ? ParsingUtils.getAsEntityList(json) : List.of();
        Ingredient ingredient = json.has("ingredient") ? ((ingredientJson = json.get("ingredient")).isJsonPrimitive() ? Ingredient.of((ItemLike[])new ItemLike[]{ParsingUtils.getAsItem(json, "ingredient")}) : (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)ingredientJson).getOrThrow()).getFirst()) : null;
        Item outputItem = ParsingUtils.getAsItem(json, "output", Items.AIR);
        float outputMultiplier = GsonHelper.getAsFloat((JsonObject)json, (String)"multiplier", (float)1.0f);
        boolean killedByPlayer = GsonHelper.getAsBoolean((JsonObject)json, (String)"killed_by_player", (boolean)false);
        return new LootFilter(type, ingredient, outputItem, outputMultiplier, killedByPlayer);
    }
}

