/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common.data;

import com.eerussianguy.ez_supervisor.common.ParsingUtils;
import com.eerussianguy.ez_supervisor.common.data.SpawnPredicate;
import com.eerussianguy.ez_supervisor.common.data.SpawnRestrictionType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;

public record SpawnRestriction(List<SpawnPredicate> predicates, boolean wipeOriginal) {
    public static Map<EntityType<?>, SpawnRestriction> readAll(JsonArray array) {
        return ParsingUtils.mapArrayMap(array, e -> SpawnRestriction.create(e.getAsJsonObject()), e -> ParsingUtils.getAsEntity(e.getAsJsonObject()));
    }

    public static Map<String, SpawnRestriction> readRuleSets(JsonObject json) {
        HashMap<String, SpawnRestriction> map = new HashMap<String, SpawnRestriction>();
        for (Map.Entry entry : json.entrySet()) {
            map.put((String)entry.getKey(), SpawnRestriction.create(((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        return map;
    }

    public static List<SpawnPredicate> readPredicatesList(JsonObject json) {
        ArrayList<SpawnPredicate> list = new ArrayList<SpawnPredicate>();
        JsonArray predicates = GsonHelper.getAsJsonArray((JsonObject)json, (String)"predicates");
        for (JsonElement element : predicates) {
            JsonObject predicateJson = element.getAsJsonObject();
            ResourceLocation id = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)predicateJson, (String)"type"));
            SpawnRestrictionType type = SpawnRestrictionType.getValueOrThrow(id);
            list.add(type.deserializer().apply(predicateJson));
        }
        return list;
    }

    public static SpawnRestriction create(JsonObject json) {
        boolean wipe = GsonHelper.getAsBoolean((JsonObject)json, (String)"overwrite_mod_predicate", (boolean)false);
        return new SpawnRestriction(SpawnRestriction.readPredicatesList(json), wipe);
    }
}

