/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common.data;

import com.eerussianguy.ez_supervisor.common.data.SpawnPredicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public record SpawnRestrictionType(Function<JsonObject, SpawnPredicate> deserializer) {
    private static final BiMap<ResourceLocation, SpawnRestrictionType> REGISTRY = HashBiMap.create();

    public static synchronized SpawnRestrictionType register(ResourceLocation id, SpawnRestrictionType type) {
        if (REGISTRY.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate key: " + String.valueOf(id));
        }
        REGISTRY.put((Object)id, (Object)type);
        return type;
    }

    public static SpawnRestrictionType getValueOrThrow(ResourceLocation id) {
        return Objects.requireNonNull((SpawnRestrictionType)REGISTRY.get((Object)id));
    }

    public static ResourceLocation getId(SpawnRestrictionType type) {
        return (ResourceLocation)REGISTRY.inverse().get((Object)type);
    }
}

