/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.common.data;

import com.eerussianguy.ez_supervisor.EZSupervisor;
import com.eerussianguy.ez_supervisor.common.ParsingUtils;
import com.eerussianguy.ez_supervisor.common.data.SpawnPredicate;
import com.eerussianguy.ez_supervisor.common.data.SpawnRestriction;
import com.eerussianguy.ez_supervisor.common.data.SpawnRestrictionType;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;

public class SpawnRestrictionTypes {
    public static final SpawnRestrictionType DISTANCE_BELOW_SEA_LEVEL = SpawnRestrictionTypes.register("distance_below_sea_level", SpawnRestrictionTypes::getDistanceBelowSeaLevel);
    public static final SpawnRestrictionType SOLID_GROUND = SpawnRestrictionTypes.register("solid_ground", SpawnRestrictionTypes::getSolidGround);
    public static final SpawnRestrictionType BRIGHTNESS = SpawnRestrictionTypes.register("brightness", SpawnRestrictionTypes::getBrightness);
    public static final SpawnRestrictionType NEVER = SpawnRestrictionTypes.register("never", SpawnRestrictionTypes::getNope);
    public static final SpawnRestrictionType DAY_COUNT = SpawnRestrictionTypes.register("day_count", SpawnRestrictionTypes::getDayCount);
    public static final SpawnRestrictionType DIFFICULTY = SpawnRestrictionTypes.register("difficulty", SpawnRestrictionTypes::getDifficulty);
    public static final SpawnRestrictionType DAY_TIME = SpawnRestrictionTypes.register("day_time", SpawnRestrictionTypes::getDayTime);
    public static final SpawnRestrictionType PLAYER_DISTANCE = SpawnRestrictionTypes.register("player_distance", SpawnRestrictionTypes::getPlayerDistance);
    public static final SpawnRestrictionType SEE_SKY = SpawnRestrictionTypes.register("see_sky", SpawnRestrictionTypes::getSeeSky);
    public static final SpawnRestrictionType TAG = SpawnRestrictionTypes.register("tag", SpawnRestrictionTypes::getTag);
    public static final SpawnRestrictionType BLOCK = SpawnRestrictionTypes.register("block", SpawnRestrictionTypes::getBlock);
    public static final SpawnRestrictionType FLUID = SpawnRestrictionTypes.register("fluid", SpawnRestrictionTypes::getFluid);
    public static final SpawnRestrictionType MOD_LOADED = SpawnRestrictionTypes.register("mod_loaded", SpawnRestrictionTypes::getModLoaded);
    public static final SpawnRestrictionType SLIME_CHUNK = SpawnRestrictionTypes.register("slime_chunk", SpawnRestrictionTypes::getSlimeChunk);
    public static final SpawnRestrictionType HEIGHT_FILTER = SpawnRestrictionTypes.register("height_filter", SpawnRestrictionTypes::getHeightFilter);
    public static final SpawnRestrictionType COUNT_NEARBY = SpawnRestrictionTypes.register("count_nearby", SpawnRestrictionTypes::getCountNearby);
    public static final SpawnRestrictionType RANDOM = SpawnRestrictionTypes.register("random", SpawnRestrictionTypes::getRandom);
    public static final SpawnRestrictionType SPAWN_TYPE = SpawnRestrictionTypes.register("spawn_type", SpawnRestrictionTypes::getSpawnType);
    public static final SpawnRestrictionType RULE_SET = SpawnRestrictionTypes.register("rule_set", SpawnRestrictionTypes::getRuleSet);
    public static final SpawnRestrictionType BIOME_TAG = SpawnRestrictionTypes.register("biome_tag", SpawnRestrictionTypes::getBiomeTag);
    public static final SpawnRestrictionType OR = SpawnRestrictionTypes.register("or", SpawnRestrictionTypes::getOr);
    public static final SpawnRestrictionType AND = SpawnRestrictionTypes.register("and", SpawnRestrictionTypes::getOr);
    public static final SpawnRestrictionType COPY = SpawnRestrictionTypes.register("copy", SpawnRestrictionTypes::getCopy);
    public static final SpawnRestrictionType MOB = SpawnRestrictionTypes.register("mob", SpawnRestrictionTypes::getMob, true);
    public static final SpawnRestrictionType MONSTER = SpawnRestrictionTypes.register("monster", SpawnRestrictionTypes::getMonster, true);
    public static final SpawnRestrictionType ANIMAL = SpawnRestrictionTypes.register("animal", SpawnRestrictionTypes::getAnimal, true);

    public static void init() {
    }

    public static SpawnPredicate getOr(JsonObject json) {
        List<SpawnPredicate> predicates = SpawnRestriction.readPredicatesList(json);
        return (entity, level, type, pos, random) -> {
            for (SpawnPredicate predicate : predicates) {
                if (!predicate.test(entity, level, type, pos, random)) continue;
                return true;
            }
            return false;
        };
    }

    public static SpawnPredicate getAnd(JsonObject json) {
        List<SpawnPredicate> predicates = SpawnRestriction.readPredicatesList(json);
        return (entity, level, type, pos, random) -> {
            for (SpawnPredicate predicate : predicates) {
                if (predicate.test(entity, level, type, pos, random)) continue;
                return false;
            }
            return true;
        };
    }

    public static SpawnPredicate getCopy(JsonObject json) {
        EntityType<?> toCopy = ParsingUtils.getAsEntity(json);
        return (entity, level, type, pos, random) -> {
            for (SpawnPredicate predicate : Objects.requireNonNull(EZSupervisor.restrictions).get(toCopy).predicates()) {
                if (predicate.test(entity, level, type, pos, random)) continue;
                return false;
            }
            return true;
        };
    }

    public static SpawnPredicate getBiomeTag(JsonObject json) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"tag")));
        return (entity, level, type, pos, random) -> level.getBiome(pos).is(tag);
    }

    public static SpawnPredicate getRuleSet(JsonObject json) {
        SpawnRestriction restriction = Objects.requireNonNull(EZSupervisor.ruleSets).get(GsonHelper.getAsString((JsonObject)json, (String)"rule"));
        return (entity, level, type, pos, random) -> restriction.predicates().stream().allMatch(p -> p.test(entity, level, type, pos, random));
    }

    public static SpawnPredicate getSpawnType(JsonObject json) {
        MobSpawnType reason = ParsingUtils.getEnum(json.get("reason"), MobSpawnType.class);
        return (entity, level, type, pos, random) -> type == reason;
    }

    public static SpawnPredicate getFluid(JsonObject json) {
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"fluid")));
        return (entity, level, type, pos, random) -> level.getBlockState(pos).getFluidState().is(fluid);
    }

    public static SpawnPredicate getRandom(JsonObject json) {
        float chance = GsonHelper.getAsFloat((JsonObject)json, (String)"chance");
        return (entity, level, type, pos, random) -> random.nextFloat() < chance;
    }

    public static SpawnPredicate getCountNearby(JsonObject json) {
        int distance = GsonHelper.getAsInt((JsonObject)json, (String)"distance");
        int count = GsonHelper.getAsInt((JsonObject)json, (String)"max_count");
        return (entity, level, type, pos, random) -> level.getEntities(entity, entity.getBoundingBox().inflate((double)distance), e -> e.getType().equals(entity.getType())).size() < count;
    }

    public static SpawnPredicate getHeightFilter(JsonObject json) {
        int min = GsonHelper.getAsInt((JsonObject)json, (String)"min", (int)-1);
        int max = GsonHelper.getAsInt((JsonObject)json, (String)"max", (int)-1);
        return (entity, level, type, pos, random) -> !(min != -1 && pos.getY() <= min || max != -1 && pos.getY() >= max);
    }

    public static SpawnPredicate getSlimeChunk(JsonObject json) {
        int rarity = GsonHelper.getAsInt((JsonObject)json, (String)"rarity", (int)10);
        return (entity, level, type, pos, random) -> {
            ChunkPos chunkpos = new ChunkPos(pos);
            return WorldgenRandom.seedSlimeChunk((int)chunkpos.x, (int)chunkpos.z, (long)level.getLevel().getSeed(), (long)987234911L).nextInt(rarity) == 0;
        };
    }

    public static SpawnPredicate getModLoaded(JsonObject json) {
        String modid = GsonHelper.getAsString((JsonObject)json, (String)"mod_id");
        return (entity, level, type, pos, random) -> ModList.get().isLoaded(modid);
    }

    public static SpawnPredicate getBlock(JsonObject json) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"block")));
        if (block == Blocks.AIR) {
            throw new JsonParseException("Air or unknown block passed to block predicate");
        }
        return (entity, level, type, pos, random) -> level.getBlockState(pos.below()).is(block);
    }

    public static SpawnPredicate getTag(JsonObject json) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"tag")));
        return (entity, level, type, pos, random) -> level.getBlockState(pos.below()).is(tag);
    }

    public static SpawnPredicate getSeeSky(JsonObject json) {
        boolean seeing = GsonHelper.getAsBoolean((JsonObject)json, (String)"can_see");
        return (entity, level, type, pos, random) -> level.canSeeSky(pos) == seeing;
    }

    public static SpawnPredicate getPlayerDistance(JsonObject json) {
        int min = GsonHelper.getAsInt((JsonObject)json, (String)"min", (int)0);
        int max = GsonHelper.getAsInt((JsonObject)json, (String)"max", (int)64);
        return (entity, level, type, pos, random) -> {
            Player player = level.getNearestPlayer(entity, (double)max);
            if (player != null && !player.isSpectator()) {
                double distSqr = player.distanceToSqr(entity);
                return distSqr > (double)(min * min) && distSqr < (double)(max * max);
            }
            return false;
        };
    }

    public static SpawnPredicate getDayTime(JsonObject json) {
        int minTicks = GsonHelper.getAsInt((JsonObject)json, (String)"min", (int)0);
        int maxTicks = GsonHelper.getAsInt((JsonObject)json, (String)"max", (int)24000);
        return (entity, level, type, pos, random) -> {
            long current = level.dayTime() % 24000L;
            return current >= (long)minTicks && current <= (long)maxTicks;
        };
    }

    public static SpawnPredicate getDifficulty(JsonObject json) {
        int min = ParsingUtils.getEnum(json, "min", Difficulty.class, Difficulty.PEACEFUL).ordinal();
        int max = ParsingUtils.getEnum(json, "max", Difficulty.class, Difficulty.HARD).ordinal();
        return (entity, level, type, pos, random) -> level.getDifficulty().ordinal() >= min && level.getDifficulty().ordinal() <= max;
    }

    public static SpawnPredicate getDayCount(JsonObject json) {
        int minDays = GsonHelper.getAsInt((JsonObject)json, (String)"min", (int)-1);
        int maxDays = GsonHelper.getAsInt((JsonObject)json, (String)"max", (int)-1);
        int everyNth = GsonHelper.getAsInt((JsonObject)json, (String)"every_n_days", (int)-1);
        return (entity, level, type, pos, random) -> {
            long passed = level.dayTime() / 24000L;
            return !(minDays != -1 && passed <= (long)minDays || maxDays != -1 && passed >= (long)maxDays || everyNth != -1 && passed % (long)everyNth != 0L);
        };
    }

    public static SpawnPredicate getNope(JsonObject json) {
        return (entity, level, type, pos, random) -> false;
    }

    public static SpawnPredicate getMonster(JsonObject json) {
        boolean anyLight = GsonHelper.getAsBoolean((JsonObject)json, (String)"any_light", (boolean)false);
        return (entity, level, type, pos, rand) -> entity instanceof Monster && anyLight ? Monster.checkAnyLightMonsterSpawnRules((EntityType)entity.getType(), (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand) : Monster.checkMonsterSpawnRules((EntityType)entity.getType(), (ServerLevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public static SpawnPredicate getAnimal(JsonObject json) {
        return (entity, level, type, pos, rand) -> entity instanceof Animal && Animal.checkAnimalSpawnRules((EntityType)entity.getType(), (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public static SpawnPredicate getMob(JsonObject json) {
        return (entity, level, type, pos, rand) -> entity instanceof Mob && Mob.checkMobSpawnRules((EntityType)entity.getType(), (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand);
    }

    public static SpawnPredicate getBrightness(JsonObject json) {
        int max = GsonHelper.getAsInt((JsonObject)json, (String)"max", (int)-1);
        int min = GsonHelper.getAsInt((JsonObject)json, (String)"min", (int)-1);
        if (max == -1 && min == -1) {
            throw new JsonSyntaxException("Failed to parse brightness json, must specify max or min");
        }
        return (entity, level, type, pos, rand) -> {
            int brightness = level.getRawBrightness(pos, 0);
            return (max == -1 || brightness <= max) && min == -1 && brightness >= min;
        };
    }

    public static SpawnPredicate getSolidGround(JsonObject json) {
        return (entity, level, type, pos, rand) -> level.getBlockState(pos.below()).is(BlockTags.VALID_SPAWN);
    }

    public static SpawnPredicate getDistanceBelowSeaLevel(JsonObject json) {
        int distance = GsonHelper.getAsInt((JsonObject)json, (String)"distance");
        return (entity, level, type, pos, rand) -> pos.getY() < level.getLevel().getChunkSource().getGenerator().getSeaLevel() - distance;
    }

    private static SpawnRestrictionType register(String id, Function<JsonObject, SpawnPredicate> deserializer) {
        return SpawnRestrictionTypes.register(id, deserializer, false);
    }

    private static SpawnRestrictionType register(String id, Function<JsonObject, SpawnPredicate> deserializer, boolean vanilla) {
        return SpawnRestrictionType.register(vanilla ? ResourceLocation.parse((String)id) : EZSupervisor.identifier(id), new SpawnRestrictionType(deserializer));
    }
}

