/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.ez_supervisor.compat;

import com.eerussianguy.ez_supervisor.common.ParsingUtils;
import com.eerussianguy.ez_supervisor.common.data.SpawnPredicate;
import com.eerussianguy.ez_supervisor.common.data.SpawnRestrictionType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.world.TFCChunkGenerator;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class TFCIntegration {
    public static final SpawnRestrictionType CLIMATE = TFCIntegration.register("climate", TFCIntegration::getClimate);
    public static final SpawnRestrictionType SEASON = TFCIntegration.register("season", TFCIntegration::getSeason);
    public static final Codec<Season> SEASON_CODEC = StringRepresentable.fromEnum(Season::values);

    public static void init() {
    }

    public static SpawnPredicate getClimate(JsonObject json) {
        ClimatePlacement placement = (ClimatePlacement)ParsingUtils.decodeCodec(ClimatePlacement.CODEC.codec(), json.get("climate"));
        return (entity, level, type, pos, random) -> {
            if (!(level.getLevel().getChunkSource().getGenerator() instanceof TFCChunkGenerator)) {
                return true;
            }
            return placement.isValid(ChunkData.get((LevelReader)level, (BlockPos)pos), pos, random, SolarCalculator.getInNorthernHemisphere((BlockPos)pos, (Level)level.getLevel()));
        };
    }

    public static SpawnPredicate getSeason(JsonObject json) {
        JsonElement el = json.get("season");
        List<Season> list = el.isJsonPrimitive() ? List.of(ParsingUtils.decodeCodec(SEASON_CODEC, el)) : ParsingUtils.mapArray(el.getAsJsonArray(), e -> ParsingUtils.decodeCodec(SEASON_CODEC, e));
        Set set = list.stream().collect(Collectors.toUnmodifiableSet());
        return (entity, level, type, pos, random) -> set.contains(Calendars.get((LevelReader)level).getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere((BlockPos)pos, (Level)level.getLevel())).getSeason());
    }

    private static SpawnRestrictionType register(String id, Function<JsonObject, SpawnPredicate> deserializer) {
        return SpawnRestrictionType.register(Helpers.identifier((String)id), new SpawnRestrictionType(deserializer));
    }
}

