/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod;

import ch.jalu.injector.Injector;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import lombok.Generated;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.skinsrestorer.api.semver.SemanticVersion;
import net.skinsrestorer.miniplaceholders.SRMiniPlaceholdersAPIExpansion;
import net.skinsrestorer.mod.SRModAdapter;
import net.skinsrestorer.mod.SRModPlatform;
import net.skinsrestorer.mod.SkinApplierMod;
import net.skinsrestorer.mod.listener.AdminInfoListener;
import net.skinsrestorer.mod.listener.PlayerJoinListener;
import net.skinsrestorer.mod.listener.ServerMessageListener;
import net.skinsrestorer.mod.wrapper.ModComponentHelper;
import net.skinsrestorer.mod.wrapper.WrapperMod;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.log.SRChatColor;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.subjects.SRSubjectWrapper;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import org.jetbrains.annotations.NotNull;

public class SRModInit
implements SRServerPlatformInit {
    public static final CustomPacketPayload.Type<RawBytePayload> SR_MESSAGE_CHANNEL = new CustomPacketPayload.Type(ResourceLocation.parse((String)"sr:messagechannel"));
    private final SRPlugin plugin;
    private final SRModAdapter adapter;
    private final Injector injector;
    private final SRLogger logger;
    private final WrapperMod wrapper;
    private final SkinsRestorerLocale locale;

    public void initSkinApplier() {
        this.plugin.registerSkinApplier((SkinApplierAccess)this.injector.getSingleton(SkinApplierMod.class), ServerPlayer.class, (SRSubjectWrapper)this.wrapper);
        this.logger.info(String.valueOf(SRChatColor.GREEN) + "Running on Minecraft " + String.valueOf(SRChatColor.YELLOW) + Platform.getMinecraftVersion() + String.valueOf(SRChatColor.GREEN) + ".");
    }

    public void initLoginProfileListener() {
        PlayerEvent.PLAYER_JOIN.register((Object)((PlayerEvent.PlayerJoin)this.injector.getSingleton(PlayerJoinListener.class)));
    }

    public void initAdminInfoListener() {
        PlayerEvent.PLAYER_JOIN.register((Object)((PlayerEvent.PlayerJoin)this.injector.getSingleton(AdminInfoListener.class)));
    }

    public void placeholderSetupHook() {
        if (this.adapter.getPluginInfo("miniplaceholders").isPresent()) {
            try {
                new SRMiniPlaceholdersAPIExpansion((SRPlatformAdapter)this.adapter, ServerPlayer.class, this.wrapper::player).register();
                this.logger.info("MiniPlaceholders expansion registered!");
            }
            catch (Throwable t) {
                this.logger.severe("Failed to load MiniPlaceholders expansion! Please check if both SkinsRestorer and MiniPlaceholders are up-to-date.", t);
            }
        }
    }

    public void checkPluginSupport() {
        this.checkViaVersion();
    }

    private void checkViaVersion() {
        Optional viaVersion = this.adapter.getPluginInfo("viaversion");
        Optional viaBackwards = this.adapter.getPluginInfo("viabackwards");
        if (viaVersion.isEmpty() || viaBackwards.isEmpty()) {
            return;
        }
        SemanticVersion viaVersionVersion = ((PluginInfo)viaVersion.get()).parsedVersion();
        SemanticVersion viaBackwardsVersion = ((PluginInfo)viaBackwards.get()).parsedVersion();
        SemanticVersion requiredVersion = new SemanticVersion(5, 0, 0);
        if (!viaVersionVersion.isOlderThan(requiredVersion) && !viaBackwardsVersion.isOlderThan(requiredVersion)) {
            return;
        }
        this.adapter.runRepeatAsync(() -> this.logger.severe("Outdated ViaVersion/ViaBackwards found! Please update to at least ViaVersion/ViaBackwards 5.0.0 for SkinsRestorer to work again!"), 2L, 60L, TimeUnit.SECONDS);
    }

    public void initPermissions() {
        Component description;
        for (PermissionRegistry permissionRegistry : PermissionRegistry.values()) {
            description = ModComponentHelper.deserialize(this.locale.getMessageRequired(this.locale.getDefaultForeign(), permissionRegistry.getDescription()));
            SRModPlatform.INSTANCE.registerPermission(permissionRegistry.getPermission(), description);
        }
        for (PermissionRegistry permissionRegistry : PermissionGroup.values()) {
            description = ModComponentHelper.deserialize(this.locale.getMessageRequired(this.locale.getDefaultForeign(), permissionRegistry.getDescription()));
            SRModPlatform.INSTANCE.registerPermission(permissionRegistry.getBasePermission(), description);
            SRModPlatform.INSTANCE.registerPermission(permissionRegistry.getWildcard(), description);
        }
    }

    public void initGUIListener() {
    }

    public void initMessageChannel() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SR_MESSAGE_CHANNEL, RawBytePayload.STREAM_CODEC, (NetworkManager.NetworkReceiver)((NetworkManager.NetworkReceiver)this.injector.getSingleton(ServerMessageListener.class)));
        NetworkManager.registerS2CPayloadType(SR_MESSAGE_CHANNEL, RawBytePayload.STREAM_CODEC);
    }

    @Inject
    @Generated
    public SRModInit(SRPlugin plugin, SRModAdapter adapter, Injector injector, SRLogger logger, WrapperMod wrapper, SkinsRestorerLocale locale) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.injector = injector;
        this.logger = logger;
        this.wrapper = wrapper;
        this.locale = locale;
    }

    public record RawBytePayload(byte[] data) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, RawBytePayload> STREAM_CODEC = StreamCodec.of((buf, payload) -> buf.writeBytes(payload.data), buf -> {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            return new RawBytePayload(bytes);
        });

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return SR_MESSAGE_CHANNEL;
        }
    }
}

