/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod;

import ch.jalu.configme.SettingsManager;
import com.google.common.collect.ImmutableMultimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import lombok.Generated;
import net.lenni0451.reflect.stream.RStream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.skinsrestorer.api.event.SkinsRestorerEvent;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.mod.SRModAdapter;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.viaversion.ViaPacketData;
import net.skinsrestorer.viaversion.ViaRefreshProvider;
import net.skinsrestorer.viaversion.ViaWorkaround;

public class SkinApplierMod
implements SkinApplierAccess<ServerPlayer> {
    private final SRModAdapter adapter;
    private final EventBusImpl eventBus;
    private final SettingsManager settings;
    private final SRLogger logger;

    public static void setGameProfileTextures(ServerPlayer player, SkinProperty property) {
        PropertyMap properties = player.getGameProfile().properties();
        ImmutableMultimap.Builder newProperties = ImmutableMultimap.builder();
        for (Map.Entry entry : properties.entries()) {
            if ("textures".equals(entry.getKey())) continue;
            newProperties.put(entry);
        }
        newProperties.put((Object)"textures", (Object)new Property("textures", property.getValue(), property.getSignature()));
        RStream.of((Object)properties).withSuper().fields().by("properties").set((Object)newProperties.build());
    }

    public void applySkin(ServerPlayer player, SkinProperty property) {
        if (player.hasDisconnected()) {
            return;
        }
        this.adapter.runAsync(() -> {
            SkinApplyEventImpl applyEvent = new SkinApplyEventImpl((Object)player, property);
            this.eventBus.callEvent((SkinsRestorerEvent)applyEvent);
            if (applyEvent.isCancelled()) {
                return;
            }
            this.adapter.runSync(Objects.requireNonNull(player.level().getServer()), () -> this.applySkinSync(player, applyEvent.getProperty()));
        });
    }

    public void applySkinSync(ServerPlayer player, SkinProperty property) {
        if (player.hasDisconnected()) {
            return;
        }
        this.ejectPassengers(player);
        SkinApplierMod.setGameProfileTextures(player, property);
        for (ServerPlayer otherPlayer : this.getSeenByPlayers(player)) {
            this.untrackAndHideEntity(otherPlayer, (Entity)player);
            this.trackAndShowEntity(otherPlayer, (Entity)player);
        }
        this.refresh(player);
    }

    private List<ServerPlayer> getSeenByPlayers(ServerPlayer player) {
        return Objects.requireNonNull(player.level().getServer()).getPlayerList().getPlayers();
    }

    private void untrackAndHideEntity(ServerPlayer currentEntity, Entity entityToHide) {
        ChunkMap tracker = currentEntity.level().getChunkSource().chunkMap;
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(entityToHide.getId());
        if (entry != null) {
            entry.removePlayer(currentEntity);
        }
        if (entityToHide instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)entityToHide;
            currentEntity.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.getUUID())));
        }
    }

    private void trackAndShowEntity(ServerPlayer currentEntity, Entity entityToShow) {
        if (entityToShow instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)entityToShow;
            currentEntity.connection.send((Packet)ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(otherPlayer)));
        }
        ChunkMap tracker = currentEntity.level().getChunkSource().chunkMap;
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(entityToShow.getId());
        if (entry != null && !entry.seenBy.contains(currentEntity.connection)) {
            entry.updatePlayer(currentEntity);
        }
    }

    private void ejectPassengers(ServerPlayer player) {
        Entity vehicle = player.getVehicle();
        if (((Boolean)this.settings.getProperty(ServerConfig.DISMOUNT_PLAYER_ON_UPDATE)).booleanValue() && vehicle != null) {
            player.stopRiding();
            if (((Boolean)this.settings.getProperty(ServerConfig.REMOUNT_PLAYER_ON_UPDATE)).booleanValue()) {
                this.adapter.runSync(Objects.requireNonNull(player.level().getServer()), () -> player.startRiding(vehicle, false, true));
            }
        }
        if (((Boolean)this.settings.getProperty(ServerConfig.DISMOUNT_PASSENGERS_ON_UPDATE)).booleanValue() && !player.getPassengers().isEmpty()) {
            player.ejectPassengers();
        }
    }

    private static void sendPacket(ServerPlayer player, Packet<?> packet) {
        player.connection.send(packet);
    }

    public void refresh(ServerPlayer player) {
        ViaRefreshProvider refreshProvider;
        ServerLevel world = player.level();
        CommonPlayerSpawnInfo spawnInfo = player.createCommonSpawnInfo(world);
        ClientboundRespawnPacket respawn = new ClientboundRespawnPacket(spawnInfo, 3);
        SkinApplierMod.sendPacket(player, new ClientboundPlayerInfoRemovePacket(List.of(player.getGameProfile().id())));
        SkinApplierMod.sendPacket(player, ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(player)));
        if (this.adapter.getPluginInfo("viabackwards").isPresent() && ViaWorkaround.shouldApplyWorkaround()) {
            this.logger.debug("Activating ViaBackwards workaround.");
            refreshProvider = d -> {
                try {
                    return ViaWorkaround.sendCustomPacketVia((ViaPacketData)((ViaPacketData)d.get()));
                }
                catch (Exception e) {
                    this.logger.severe("Error while refreshing skin via ViaBackwards", (Throwable)e);
                    return false;
                }
            };
        } else {
            refreshProvider = ViaRefreshProvider.NO_OP;
        }
        if (refreshProvider.test(() -> new ViaPacketData(player.getUUID(), player.level().registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE).getId((Object)player.level().dimensionType()), spawnInfo.seed(), spawnInfo.gameType().getId(), spawnInfo.isFlat()))) {
            SkinApplierMod.sendPacket(player, respawn);
        }
        player.onUpdateAbilities();
        player.connection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        player.resetSentInfo();
        PlayerList playerList = Objects.requireNonNull(player.level().getServer()).getPlayerList();
        playerList.sendPlayerPermissionLevel(player);
        playerList.sendLevelInfo(player, world);
        playerList.sendAllPlayerInfo(player);
        for (MobEffectInstance effect : player.getActiveEffects()) {
            SkinApplierMod.sendPacket(player, new ClientboundUpdateMobEffectPacket(player.getId(), effect, false));
        }
    }

    @Inject
    @Generated
    public SkinApplierMod(SRModAdapter adapter, EventBusImpl eventBus, SettingsManager settings, SRLogger logger) {
        this.adapter = adapter;
        this.eventBus = eventBus;
        this.settings = settings;
        this.logger = logger;
    }
}

