/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod.utils;

import ch.jalu.configme.SettingsManager;
import java.util.Objects;
import javax.inject.Inject;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.skinsrestorer.shared.commands.SoundProvider;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.sound.SoundParser;
import net.skinsrestorer.shared.subjects.SRPlayer;

public class SoundUtil
implements SoundProvider {
    private final SettingsManager settings;
    private final SRLogger logger;

    public void playSound(SRPlayer player) {
        if (!((Boolean)this.settings.getProperty(ServerConfig.SOUND_ENABLED)).booleanValue()) {
            return;
        }
        ServerPlayer p = (ServerPlayer)player.getAs(ServerPlayer.class);
        String sound = (String)this.settings.getProperty(ServerConfig.SOUND_VALUE);
        SoundParser.Record record = SoundParser.parse((String)sound);
        if (record == null) {
            this.logger.warning("Invalid sound value in config: %s".formatted(sound));
            return;
        }
        this.logger.debug("Playing sound for player: %s".formatted(player.getName()));
        SoundEvent soundEvent = BuiltInRegistries.SOUND_EVENT.stream().filter(soundEvent1 -> soundEvent1.location().getPath().replace(".", "_").equalsIgnoreCase(record.getSound())).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid sound: " + record.getSound()));
        SoundSource source = SoundSource.valueOf((String)record.getCategory());
        p.playNotifySound(Objects.requireNonNull(soundEvent), source, record.getVolume(), record.getPitch());
    }

    @Inject
    @Generated
    public SoundUtil(SettingsManager settings, SRLogger logger) {
        this.settings = settings;
        this.logger = logger;
    }
}

