/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod;

import ch.jalu.injector.Injector;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import dev.architectury.platform.Platform;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3944;
import net.minecraft.class_9296;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.mod.SRModPlatform;
import net.skinsrestorer.mod.gui.ModGUI;
import net.skinsrestorer.mod.utils.SoundUtil;
import net.skinsrestorer.mod.wrapper.WrapperMod;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.commands.SoundProvider;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.SRHelpers;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;

public class SRModAdapter
implements SRServerAdapter {
    private static final List<Object> REFERENCES_TO_PREVENT_GC = new ArrayList<Object>();
    private final Injector injector;
    private final ScheduledExecutorService asyncScheduler = Executors.newSingleThreadScheduledExecutor();

    @Inject
    public SRModAdapter(Injector injector) {
        this.injector = injector;
    }

    public Object createMetricsInstance() {
        return null;
    }

    public InputStream getResource(String resource) {
        return SRPlatformAdapter.class.getClassLoader().getResourceAsStream(resource);
    }

    public CommandManager<SRCommandSender> createCommandManager() {
        WrapperMod wrapper = (WrapperMod)this.injector.getSingleton(WrapperMod.class);
        return SRModPlatform.INSTANCE.createCommandManager((ExecutionCoordinator<SRCommandSender>)ExecutionCoordinator.asyncCoordinator(), (SenderMapper<class_2168, SRCommandSender>)SenderMapper.create(wrapper::commandSender, wrapper::unwrap));
    }

    public void runAsync(Runnable runnable) {
        this.asyncScheduler.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public void runAsyncDelayed(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.asyncScheduler.schedule(runnable, delay, timeUnit);
    }

    public void runSync(SRCommandSender sender, Runnable runnable) {
        this.runSync(((class_2168)sender.getAs(class_2168.class)).method_9211(), runnable);
    }

    public void runSync(MinecraftServer server, Runnable runnable) {
        server.method_63588((Runnable)server.method_16209(runnable));
    }

    public void runSyncToPlayer(SRPlayer player, Runnable runnable) {
        this.runSync((SRCommandSender)player, runnable);
    }

    public boolean determineProxy() {
        return Set.of("fabricproxy", "fabricproxy-lite", "neoforwarding", "neovelocity").stream().anyMatch(mod -> this.getPluginInfo((String)mod).isPresent());
    }

    public void openGUI(SRPlayer player, SRInventory srInventory) {
        class_3908 inventory = ((ModGUI)this.injector.getSingleton(ModGUI.class)).createGUI(srInventory);
        this.runSyncToPlayer(player, () -> this.openMenuCustom((class_3222)player.getAs(class_3222.class), inventory));
    }

    private void openMenuCustom(class_3222 player, class_3908 menuProvider) {
        player.method_14237();
        class_1703 abstractContainerMenu = menuProvider.createMenu(player.field_13986, player.method_31548(), (class_1657)player);
        if (abstractContainerMenu == null) {
            return;
        }
        player.field_13987.method_14364((class_2596)new class_3944(abstractContainerMenu.field_7763, abstractContainerMenu.method_17358(), menuProvider.method_5476()));
        player.method_14235(abstractContainerMenu);
        player.field_7512 = abstractContainerMenu;
    }

    public void giveSkullItem(SRPlayer player, SRServerPluginMessage.GiveSkullChannelPayload giveSkullPayload) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"textures", (Object)new Property("textures", SRHelpers.encodeHashToTexturesValue((String)giveSkullPayload.textureHash()), null));
        PropertyMap propertyMap = new PropertyMap((Multimap)builder.build());
        GameProfile gameProfile = new GameProfile(class_156.field_25140, "", propertyMap);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        stack.method_57366(class_9326.method_57841().method_57854(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)gameProfile)).method_57852());
        ((class_3222)player.getAs(class_3222.class)).method_31548().method_7394(stack);
    }

    public Class<? extends SoundProvider> getSoundProviderClass() {
        return SoundUtil.class;
    }

    public void runRepeatAsync(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
        this.asyncScheduler.scheduleWithFixedDelay(runnable, delay, interval, timeUnit);
    }

    public void extendLifeTime(Object plugin, Object object) {
        REFERENCES_TO_PREVENT_GC.add(object);
    }

    public boolean supportsDefaultPermissions() {
        return true;
    }

    public void shutdownCleanup() {
        this.asyncScheduler.shutdown();
        REFERENCES_TO_PREVENT_GC.clear();
    }

    public String getPlatformVersion() {
        return Platform.getMinecraftVersion();
    }

    public String getPlatformName() {
        return SRModPlatform.INSTANCE.getPlatformName();
    }

    public String getPlatformVendor() {
        return "N/A";
    }

    public net.skinsrestorer.shared.info.Platform getPlatform() {
        return net.skinsrestorer.shared.info.Platform.BUKKIT;
    }

    public List<PluginInfo> getPlugins() {
        return Platform.getMods().stream().map(plugin -> new PluginInfo(true, plugin.getModId(), plugin.getName(), plugin.getVersion(), "N/A", Map.of("homepage", plugin.getHomepage().orElse("N/A"), "sources", plugin.getSources().orElse("N/A"), "issueTracker", plugin.getIssueTracker().orElse("N/A")), List.copyOf(plugin.getAuthors()))).collect(Collectors.toList());
    }

    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return ((class_3222)player.getAs(class_3222.class)).method_7334().properties().values().stream().map(property -> SkinProperty.tryParse((String)property.name(), (String)property.value(), (String)property.signature())).flatMap(Optional::stream).findFirst();
    }

    public Collection<SRPlayer> getOnlinePlayers(SRCommandSender sender) {
        return ((class_2168)sender.getAs(class_2168.class)).method_9211().method_3760().method_14571().stream().map(((WrapperMod)this.injector.getSingleton(WrapperMod.class))::player).collect(Collectors.toList());
    }

    public Optional<SRPlayer> getPlayer(SRCommandSender sender, UUID uniqueId) {
        return Optional.ofNullable(((class_2168)sender.getAs(class_2168.class)).method_9211().method_3760().method_14602(uniqueId)).map(((WrapperMod)this.injector.getSingleton(WrapperMod.class))::player);
    }
}

