/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod;

import ch.jalu.configme.SettingsManager;
import com.google.common.collect.ImmutableMultimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import lombok.Generated;
import net.lenni0451.reflect.stream.RStream;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2783;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3898;
import net.minecraft.class_7828;
import net.minecraft.class_7924;
import net.minecraft.class_8589;
import net.skinsrestorer.api.event.SkinsRestorerEvent;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.mod.SRModAdapter;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.viaversion.ViaPacketData;
import net.skinsrestorer.viaversion.ViaRefreshProvider;
import net.skinsrestorer.viaversion.ViaWorkaround;

public class SkinApplierMod
implements SkinApplierAccess<class_3222> {
    private final SRModAdapter adapter;
    private final EventBusImpl eventBus;
    private final SettingsManager settings;
    private final SRLogger logger;

    public static void setGameProfileTextures(class_3222 player, SkinProperty property) {
        PropertyMap properties = player.method_7334().properties();
        ImmutableMultimap.Builder newProperties = ImmutableMultimap.builder();
        for (Map.Entry entry : properties.entries()) {
            if ("textures".equals(entry.getKey())) continue;
            newProperties.put(entry);
        }
        newProperties.put((Object)"textures", (Object)new Property("textures", property.getValue(), property.getSignature()));
        RStream.of((Object)properties).withSuper().fields().by("properties").set((Object)newProperties.build());
    }

    public void applySkin(class_3222 player, SkinProperty property) {
        if (player.method_14239()) {
            return;
        }
        this.adapter.runAsync(() -> {
            SkinApplyEventImpl applyEvent = new SkinApplyEventImpl((Object)player, property);
            this.eventBus.callEvent((SkinsRestorerEvent)applyEvent);
            if (applyEvent.isCancelled()) {
                return;
            }
            this.adapter.runSync(Objects.requireNonNull(player.method_51469().method_8503()), () -> this.applySkinSync(player, applyEvent.getProperty()));
        });
    }

    public void applySkinSync(class_3222 player, SkinProperty property) {
        if (player.method_14239()) {
            return;
        }
        this.ejectPassengers(player);
        SkinApplierMod.setGameProfileTextures(player, property);
        for (class_3222 otherPlayer : this.getSeenByPlayers(player)) {
            this.untrackAndHideEntity(otherPlayer, (class_1297)player);
            this.trackAndShowEntity(otherPlayer, (class_1297)player);
        }
        this.refresh(player);
    }

    private List<class_3222> getSeenByPlayers(class_3222 player) {
        return Objects.requireNonNull(player.method_51469().method_8503()).method_3760().method_14571();
    }

    private void untrackAndHideEntity(class_3222 currentEntity, class_1297 entityToHide) {
        class_3898 tracker = currentEntity.method_51469().method_14178().field_17254;
        class_3898.class_3208 entry = (class_3898.class_3208)tracker.field_18242.get(entityToHide.method_5628());
        if (entry != null) {
            entry.method_18733(currentEntity);
        }
        if (entityToHide instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)entityToHide;
            currentEntity.field_13987.method_14364((class_2596)new class_7828(List.of(otherPlayer.method_5667())));
        }
    }

    private void trackAndShowEntity(class_3222 currentEntity, class_1297 entityToShow) {
        if (entityToShow instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)entityToShow;
            currentEntity.field_13987.method_14364((class_2596)class_2703.method_43886(List.of(otherPlayer)));
        }
        class_3898 tracker = currentEntity.method_51469().method_14178().field_17254;
        class_3898.class_3208 entry = (class_3898.class_3208)tracker.field_18242.get(entityToShow.method_5628());
        if (entry != null && !entry.field_18250.contains(currentEntity.field_13987)) {
            entry.method_18736(currentEntity);
        }
    }

    private void ejectPassengers(class_3222 player) {
        class_1297 vehicle = player.method_5854();
        if (((Boolean)this.settings.getProperty(ServerConfig.DISMOUNT_PLAYER_ON_UPDATE)).booleanValue() && vehicle != null) {
            player.method_5848();
            if (((Boolean)this.settings.getProperty(ServerConfig.REMOUNT_PLAYER_ON_UPDATE)).booleanValue()) {
                this.adapter.runSync(Objects.requireNonNull(player.method_51469().method_8503()), () -> player.method_5873(vehicle, false, true));
            }
        }
        if (((Boolean)this.settings.getProperty(ServerConfig.DISMOUNT_PASSENGERS_ON_UPDATE)).booleanValue() && !player.method_5685().isEmpty()) {
            player.method_5772();
        }
    }

    private static void sendPacket(class_3222 player, class_2596<?> packet) {
        player.field_13987.method_14364(packet);
    }

    public void refresh(class_3222 player) {
        ViaRefreshProvider refreshProvider;
        class_3218 world = player.method_51469();
        class_8589 spawnInfo = player.method_52374(world);
        class_2724 respawn = new class_2724(spawnInfo, 3);
        SkinApplierMod.sendPacket(player, new class_7828(List.of(player.method_7334().id())));
        SkinApplierMod.sendPacket(player, class_2703.method_43886(List.of(player)));
        if (this.adapter.getPluginInfo("viabackwards").isPresent() && ViaWorkaround.shouldApplyWorkaround()) {
            this.logger.debug("Activating ViaBackwards workaround.");
            refreshProvider = d -> {
                try {
                    return ViaWorkaround.sendCustomPacketVia((ViaPacketData)((ViaPacketData)d.get()));
                }
                catch (Exception e) {
                    this.logger.severe("Error while refreshing skin via ViaBackwards", (Throwable)e);
                    return false;
                }
            };
        } else {
            refreshProvider = ViaRefreshProvider.NO_OP;
        }
        if (refreshProvider.test(() -> new ViaPacketData(player.method_5667(), player.method_51469().method_30349().method_30530(class_7924.field_41241).method_10206((Object)player.method_51469().method_8597()), spawnInfo.comp_1555(), spawnInfo.comp_1556().method_8379(), spawnInfo.comp_1559()))) {
            SkinApplierMod.sendPacket(player, respawn);
        }
        player.method_7355();
        player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        player.method_14217();
        class_3324 playerList = Objects.requireNonNull(player.method_51469().method_8503()).method_3760();
        playerList.method_14576(player);
        playerList.method_14606(player, world);
        playerList.method_14594(player);
        for (class_1293 effect : player.method_6026()) {
            SkinApplierMod.sendPacket(player, new class_2783(player.method_5628(), effect, false));
        }
    }

    @Inject
    @Generated
    public SkinApplierMod(SRModAdapter adapter, EventBusImpl eventBus, SettingsManager settings, SRLogger logger) {
        this.adapter = adapter;
        this.eventBus = eventBus;
        this.settings = settings;
        this.logger = logger;
    }
}

