/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod;

import ch.jalu.injector.Injector;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import dev.architectury.platform.Platform;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.mod.SRModPlatform;
import net.skinsrestorer.mod.gui.ModGUI;
import net.skinsrestorer.mod.utils.SoundUtil;
import net.skinsrestorer.mod.wrapper.WrapperMod;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.commands.SoundProvider;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.SRHelpers;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;

public class SRModAdapter
implements SRServerAdapter {
    private static final List<Object> REFERENCES_TO_PREVENT_GC = new ArrayList<Object>();
    private final Injector injector;
    private final ScheduledExecutorService asyncScheduler = Executors.newSingleThreadScheduledExecutor();

    @Inject
    public SRModAdapter(Injector injector) {
        this.injector = injector;
    }

    public Object createMetricsInstance() {
        return null;
    }

    public InputStream getResource(String resource) {
        return SRPlatformAdapter.class.getClassLoader().getResourceAsStream(resource);
    }

    public CommandManager<SRCommandSender> createCommandManager() {
        WrapperMod wrapper = (WrapperMod)this.injector.getSingleton(WrapperMod.class);
        return SRModPlatform.INSTANCE.createCommandManager((ExecutionCoordinator<SRCommandSender>)ExecutionCoordinator.asyncCoordinator(), (SenderMapper<CommandSourceStack, SRCommandSender>)SenderMapper.create(wrapper::commandSender, wrapper::unwrap));
    }

    public void runAsync(Runnable runnable) {
        this.asyncScheduler.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public void runAsyncDelayed(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.asyncScheduler.schedule(runnable, delay, timeUnit);
    }

    public void runSync(SRCommandSender sender, Runnable runnable) {
        this.runSync(((CommandSourceStack)sender.getAs(CommandSourceStack.class)).getServer(), runnable);
    }

    public void runSync(MinecraftServer server, Runnable runnable) {
        server.schedule((Runnable)server.wrapRunnable(runnable));
    }

    public void runSyncToPlayer(SRPlayer player, Runnable runnable) {
        this.runSync((SRCommandSender)player, runnable);
    }

    public boolean determineProxy() {
        return Set.of("fabricproxy", "fabricproxy-lite", "neoforwarding", "neovelocity").stream().anyMatch(mod -> this.getPluginInfo((String)mod).isPresent());
    }

    public void openGUI(SRPlayer player, SRInventory srInventory) {
        MenuProvider inventory = ((ModGUI)this.injector.getSingleton(ModGUI.class)).createGUI(srInventory);
        this.runSyncToPlayer(player, () -> this.openMenuCustom((ServerPlayer)player.getAs(ServerPlayer.class), inventory));
    }

    private void openMenuCustom(ServerPlayer player, MenuProvider menuProvider) {
        player.nextContainerCounter();
        AbstractContainerMenu abstractContainerMenu = menuProvider.createMenu(player.containerCounter, player.getInventory(), (Player)player);
        if (abstractContainerMenu == null) {
            return;
        }
        player.connection.send((Packet)new ClientboundOpenScreenPacket(abstractContainerMenu.containerId, abstractContainerMenu.getType(), menuProvider.getDisplayName()));
        player.initMenu(abstractContainerMenu);
        player.containerMenu = abstractContainerMenu;
    }

    public void giveSkullItem(SRPlayer player, SRServerPluginMessage.GiveSkullChannelPayload giveSkullPayload) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"textures", (Object)new Property("textures", SRHelpers.encodeHashToTexturesValue((String)giveSkullPayload.textureHash()), null));
        PropertyMap propertyMap = new PropertyMap((Multimap)builder.build());
        GameProfile gameProfile = new GameProfile(Util.NIL_UUID, "", propertyMap);
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        stack.applyComponents(DataComponentPatch.builder().set(DataComponents.PROFILE, (Object)ResolvableProfile.createResolved((GameProfile)gameProfile)).build());
        ((ServerPlayer)player.getAs(ServerPlayer.class)).getInventory().add(stack);
    }

    public Class<? extends SoundProvider> getSoundProviderClass() {
        return SoundUtil.class;
    }

    public void runRepeatAsync(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
        this.asyncScheduler.scheduleWithFixedDelay(runnable, delay, interval, timeUnit);
    }

    public void extendLifeTime(Object plugin, Object object) {
        REFERENCES_TO_PREVENT_GC.add(object);
    }

    public boolean supportsDefaultPermissions() {
        return true;
    }

    public void shutdownCleanup() {
        this.asyncScheduler.shutdown();
        REFERENCES_TO_PREVENT_GC.clear();
    }

    public String getPlatformVersion() {
        return Platform.getMinecraftVersion();
    }

    public String getPlatformName() {
        return SRModPlatform.INSTANCE.getPlatformName();
    }

    public String getPlatformVendor() {
        return "N/A";
    }

    public net.skinsrestorer.shared.info.Platform getPlatform() {
        return net.skinsrestorer.shared.info.Platform.BUKKIT;
    }

    public List<PluginInfo> getPlugins() {
        return Platform.getMods().stream().map(plugin -> new PluginInfo(true, plugin.getModId(), plugin.getName(), plugin.getVersion(), "N/A", Map.of("homepage", plugin.getHomepage().orElse("N/A"), "sources", plugin.getSources().orElse("N/A"), "issueTracker", plugin.getIssueTracker().orElse("N/A")), List.copyOf(plugin.getAuthors()))).collect(Collectors.toList());
    }

    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return ((ServerPlayer)player.getAs(ServerPlayer.class)).getGameProfile().properties().values().stream().map(property -> SkinProperty.tryParse((String)property.name(), (String)property.value(), (String)property.signature())).flatMap(Optional::stream).findFirst();
    }

    public Collection<SRPlayer> getOnlinePlayers(SRCommandSender sender) {
        return ((CommandSourceStack)sender.getAs(CommandSourceStack.class)).getServer().getPlayerList().getPlayers().stream().map(((WrapperMod)this.injector.getSingleton(WrapperMod.class))::player).collect(Collectors.toList());
    }

    public Optional<SRPlayer> getPlayer(SRCommandSender sender, UUID uniqueId) {
        return Optional.ofNullable(((CommandSourceStack)sender.getAs(CommandSourceStack.class)).getServer().getPlayerList().getPlayer(uniqueId)).map(((WrapperMod)this.injector.getSingleton(WrapperMod.class))::player);
    }
}

