/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod.gui;

import ch.jalu.injector.Injector;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.skinsrestorer.mod.wrapper.ModComponentHelper;
import net.skinsrestorer.mod.wrapper.WrapperMod;
import net.skinsrestorer.shared.gui.ActionDataCallback;
import net.skinsrestorer.shared.gui.ClickEventType;
import net.skinsrestorer.shared.gui.GUIManager;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.utils.SRHelpers;
import org.jetbrains.annotations.NotNull;

public class ModGUI
implements GUIManager<MenuProvider> {
    private final Injector injector;

    private ItemStack createItem(SRInventory.Item entry) {
        Item item = switch (entry.materialType()) {
            default -> throw new MatchException(null, null);
            case SRInventory.MaterialType.DIRT -> Items.DIRT;
            case SRInventory.MaterialType.SKULL -> Items.PLAYER_HEAD;
            case SRInventory.MaterialType.ARROW -> Items.ARROW;
            case SRInventory.MaterialType.BARRIER -> Items.BARRIER;
            case SRInventory.MaterialType.BOOKSHELF -> Items.BOOKSHELF;
            case SRInventory.MaterialType.ENDER_EYE -> Items.ENDER_EYE;
            case SRInventory.MaterialType.ENCHANTING_TABLE -> Items.ENCHANTING_TABLE;
        };
        PatchedDataComponentMap dataComponentMap = new PatchedDataComponentMap(item.components());
        entry.textureHash().ifPresent(hash -> {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)"textures", (Object)new Property("textures", SRHelpers.encodeHashToTexturesValue((String)hash)));
            PropertyMap propertyMap = new PropertyMap((Multimap)builder.build());
            GameProfile gameProfile = new GameProfile(Util.NIL_UUID, "", propertyMap);
            dataComponentMap.set(DataComponents.PROFILE, (Object)ResolvableProfile.createResolved((GameProfile)gameProfile));
        });
        dataComponentMap.set(DataComponents.ITEM_NAME, (Object)ModComponentHelper.deserialize(entry.displayName()));
        dataComponentMap.set(DataComponents.LORE, (Object)new ItemLore(entry.lore().stream().map(ModComponentHelper::deserialize).toList()));
        if (entry.enchantmentGlow()) {
            dataComponentMap.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        }
        return new ItemStack((Holder)item.builtInRegistryHolder(), 1, dataComponentMap.asPatch());
    }

    public MenuProvider createGUI(final SRInventory srInventory) {
        return new MenuProvider(){

            public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player inventoryOwner) {
                Map<Integer, Map<ClickEventType, SRInventory.ClickEventAction>> handlers = srInventory.items().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((SRInventory.Item)entry.getValue()).clickHandlers()));
                SimpleContainer container = new SimpleContainer(9 * srInventory.rows());
                srInventory.items().forEach((arg_0, arg_1) -> this.lambda$createMenu$1((Container)container, arg_0, arg_1));
                return new SRGUIMenu(srInventory, id, inventory, (Container)container, handlers, (ActionDataCallback)ModGUI.this.injector.getSingleton(ActionDataCallback.class), (WrapperMod)ModGUI.this.injector.getSingleton(WrapperMod.class));
            }

            @NotNull
            public Component getDisplayName() {
                return ModComponentHelper.deserialize(srInventory.title());
            }

            private /* synthetic */ void lambda$createMenu$1(Container container, Integer key, SRInventory.Item value) {
                container.setItem(key.intValue(), ModGUI.this.createItem(value));
            }
        };
    }

    @Inject
    @Generated
    public ModGUI(Injector injector) {
        this.injector = injector;
    }

    public static class SRGUIMenu
    extends ChestMenu {
        private final Map<Integer, Map<ClickEventType, SRInventory.ClickEventAction>> handlers;
        private final ActionDataCallback dataCallback;
        private final WrapperMod wrapper;

        public SRGUIMenu(SRInventory srInventory, int id, Inventory inventory, Container container, Map<Integer, Map<ClickEventType, SRInventory.ClickEventAction>> handlers, ActionDataCallback dataCallback, WrapperMod wrapper) {
            super(switch (srInventory.rows()) {
                case 1 -> MenuType.GENERIC_9x1;
                case 2 -> MenuType.GENERIC_9x2;
                case 3 -> MenuType.GENERIC_9x3;
                case 4 -> MenuType.GENERIC_9x4;
                case 5 -> MenuType.GENERIC_9x5;
                case 6 -> MenuType.GENERIC_9x6;
                default -> throw new IllegalArgumentException("Invalid rows: " + srInventory.rows());
            }, id, inventory, container, srInventory.rows());
            this.handlers = handlers;
            this.dataCallback = dataCallback;
            this.wrapper = wrapper;
        }

        public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player clickingPlayer) {
            Map<ClickEventType, SRInventory.ClickEventAction> slotHandlers = this.handlers.get(slotId);
            if (slotHandlers == null) {
                return;
            }
            SRInventory.ClickEventAction action = slotHandlers.get(switch (clickType) {
                case ClickType.PICKUP -> {
                    switch (button) {
                        case 0: {
                            yield ClickEventType.LEFT;
                        }
                        case 1: {
                            yield ClickEventType.RIGHT;
                        }
                    }
                    yield ClickEventType.OTHER;
                }
                case ClickType.QUICK_MOVE -> {
                    if (button == 0) {
                        yield ClickEventType.SHIFT_LEFT;
                    }
                    yield ClickEventType.OTHER;
                }
                default -> ClickEventType.OTHER;
            });
            if (action == null) {
                return;
            }
            this.dataCallback.handle(this.wrapper.player((ServerPlayer)clickingPlayer), action);
        }
    }
}

