/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.mod.neoforge;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import net.skinsrestorer.mod.SRModPlatform;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.utils.Tristate;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.neoforge.NeoForgeServerCommandManager;

public class SRModPlatformImpl
implements SRModPlatform {
    private static final Map<String, PermissionNode<Boolean>> PERMISSIONS = new HashMap<String, PermissionNode<Boolean>>();

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public CommandManager<SRCommandSender> createCommandManager(ExecutionCoordinator<SRCommandSender> executionCoordinator, SenderMapper<CommandSourceStack, SRCommandSender> senderMapper) {
        return new NeoForgeServerCommandManager(executionCoordinator, senderMapper);
    }

    @Override
    public Tristate test(CommandSourceStack stack, Permission permission) {
        if (!stack.isPlayer()) {
            return stack.hasPermission(stack.getServer().operatorUserPermissionLevel()) ? Tristate.TRUE : Tristate.UNDEFINED;
        }
        return (Boolean)PermissionAPI.getPermission((ServerPlayer)Objects.requireNonNull(stack.getPlayer()), PERMISSIONS.get(permission.getPermissionString()), (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false ? Tristate.TRUE : Tristate.FALSE;
    }

    @Override
    public void registerPermission(Permission permission, Component description) {
        int dotIndex = permission.getPermissionString().indexOf(46);
        String beforeDot = permission.getPermissionString().substring(0, dotIndex);
        String afterDot = permission.getPermissionString().substring(dotIndex + 1);
        PermissionNode node = new PermissionNode(beforeDot, afterDot, PermissionTypes.BOOLEAN, (arg, uUID, permissionDynamicContexts) -> permission.isInDefaultGroup(), new PermissionDynamicContextKey[0]);
        node.setInformation((Component)Component.literal((String)permission.getPermissionString()), description);
        PERMISSIONS.put(permission.getPermissionString(), (PermissionNode<Boolean>)node);
        NeoForge.EVENT_BUS.addListener(PermissionGatherEvent.Nodes.class, event -> event.addNodes(new PermissionNode[]{node}));
    }
}

