/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.bukkit.utils.SchedulerProvider;
import net.skinsrestorer.shadow.javax.inject.Inject;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitSchedulerProvider
implements SchedulerProvider {
    private static final long MILLISECONDS_PER_TICK = 50L;
    private final Server server;
    private final JavaPlugin plugin;

    @Override
    public void runAsync(Runnable runnable) {
        this.server.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
    }

    @Override
    public void runAsyncDelayed(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.server.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, timeUnit.toMillis(delay) / 50L);
    }

    @Override
    public void runSync(Runnable runnable) {
        this.server.getScheduler().runTask((Plugin)this.plugin, runnable);
    }

    @Override
    public void runSyncDelayed(Runnable runnable, long ticks) {
        this.server.getScheduler().runTaskLater((Plugin)this.plugin, runnable, ticks);
    }

    @Override
    public void runSyncToEntity(Entity entity, Runnable runnable) {
        this.runSync(runnable);
    }

    @Override
    public void runSyncToEntityDelayed(Entity entity, Runnable runnable, long ticks) {
        this.runSyncDelayed(runnable, ticks);
    }

    @Override
    public void runRepeatAsync(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
        this.server.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, timeUnit.toMillis(delay) / 50L, timeUnit.toMillis(interval) / 50L);
    }

    @Override
    public void unregisterTasks() {
        this.server.getScheduler().cancelTasks((Plugin)this.plugin);
    }

    @Inject
    @Generated
    public BukkitSchedulerProvider(Server server, JavaPlugin plugin) {
        this.server = server;
        this.plugin = plugin;
    }
}

