/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.miniplaceholders;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.utils.Tags;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.storage.HardcodedSkins;
import net.skinsrestorer.shared.subjects.SRPlayer;

public class SRMiniPlaceholdersAPIExpansion<P> {
    private final SRPlatformAdapter adapter;
    private final Class<P> playerClassRaw;
    private final Function<P, SRPlayer> playerProvider;

    public void register() {
        Class<P> playerClass = this.playerClassRaw;
        ((Expansion)Expansion.builder((String)"skinsrestorer").version(BuildData.VERSION).author("SRTeam").audiencePlaceholder(playerClass, "skin_name_or_empty", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            Optional<SkinIdentifier> skin = SkinsRestorerProvider.get().getPlayerStorage().getSkinIdOfPlayer(player.getUniqueId());
            if (skin.isPresent()) {
                return Tag.preProcessParsed((String)skin.get().getIdentifier());
            }
            return Tags.EMPTY_TAG;
        }).audiencePlaceholder(playerClass, "skin_name_or_player_name", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            Optional<SkinIdentifier> skin = SkinsRestorerProvider.get().getPlayerStorage().getSkinIdOfPlayer(player.getUniqueId());
            return (Tag)skin.map(skinIdentifier -> Tag.preProcessParsed((String)skinIdentifier.getIdentifier())).orElseGet(() -> Tag.preProcessParsed((String)player.getName()));
        }).audiencePlaceholder(playerClass, "texture_url_or_empty", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureUrl).orElse(Tags.EMPTY_TAG);
        }).audiencePlaceholder(playerClass, "texture_url_or_steve", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureUrl).orElseGet(() -> this.extractTextureUrl(HardcodedSkins.STEVE.getProperty()));
        }).audiencePlaceholder(playerClass, "texture_url_or_alex", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureUrl).orElseGet(() -> this.extractTextureUrl(HardcodedSkins.ALEX.getProperty()));
        }).audiencePlaceholder(playerClass, "texture_id_or_empty", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureHash).orElse(Tags.EMPTY_TAG);
        }).audiencePlaceholder(playerClass, "texture_id_or_steve", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureHash).orElseGet(() -> this.extractTextureHash(HardcodedSkins.STEVE.getProperty()));
        }).audiencePlaceholder(playerClass, "texture_id_or_alex", (audience, queue, ctx) -> {
            SRPlayer player = this.playerProvider.apply(audience);
            return this.adapter.getSkinProperty(player).map(this::extractTextureHash).orElseGet(() -> this.extractTextureHash(HardcodedSkins.ALEX.getProperty()));
        }).build()).register();
    }

    private Tag extractTextureUrl(SkinProperty property) {
        return Tag.preProcessParsed((String)PropertyUtils.getSkinTextureUrl(property));
    }

    private Tag extractTextureHash(SkinProperty property) {
        return Tag.preProcessParsed((String)PropertyUtils.getSkinTextureHash(property));
    }

    @Generated
    public SRMiniPlaceholdersAPIExpansion(SRPlatformAdapter adapter, Class<P> playerClassRaw, Function<P, SRPlayer> playerProvider) {
        this.adapter = adapter;
        this.playerClassRaw = playerClassRaw;
        this.playerProvider = playerProvider;
    }
}

